/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.EnumMap;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public enum ListType implements Type
{
    NMT("NMTOKENS", AtomType.NMT),
    ENT("ENTITIES", AtomType.ENT),
    IDR("IDREFS", AtomType.IDR);

    private static final ListType[] VALUES;
    private final AtomType type;
    private final QNm name;
    private EnumMap<Occ, SeqType> seqTypes;

    static {
        VALUES = ListType.values();
    }

    private ListType(String name, AtomType type) {
        this.name = new QNm(name, QueryText.XS_URI);
        this.type = type;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public final boolean isUntyped() {
        return false;
    }

    @Override
    public final boolean isNumberOrUntyped() {
        return false;
    }

    @Override
    public final boolean isStringOrUntyped() {
        return false;
    }

    @Override
    public final boolean isSortable() {
        return false;
    }

    @Override
    public final byte[] string() {
        return this.name.string();
    }

    @Override
    public final Value cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        byte[][] values = Token.split(Token.normalize(item.string(info)), 32);
        ValueBuilder vb = new ValueBuilder(qc);
        byte[][] byArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] value = byArray[n2];
            vb.add(this.type.cast(Str.get(value), qc, sc, info));
            ++n2;
        }
        return vb.value();
    }

    @Override
    public final Value cast(Object value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        return this.cast(Str.get(value, qc, info), qc, sc, info);
    }

    @Override
    public final Value castString(String value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        return this.cast(value, qc, sc, info);
    }

    @Override
    public SeqType seqType(Occ occ) {
        if (this.seqTypes == null) {
            this.seqTypes = new EnumMap(Occ.class);
        }
        return this.seqTypes.computeIfAbsent(occ, o -> new SeqType(this, (Occ)((Object)o)));
    }

    @Override
    public final boolean eq(Type tp) {
        return this == tp;
    }

    @Override
    public final boolean instanceOf(Type tp) {
        return this == tp;
    }

    @Override
    public final Type union(Type tp) {
        return this == tp ? tp : AtomType.ITEM;
    }

    @Override
    public final Type intersect(Type tp) {
        return this == tp ? this : (tp.instanceOf(this) ? tp : null);
    }

    @Override
    public final AtomType atomic() {
        return null;
    }

    @Override
    public final Type.ID id() {
        return null;
    }

    @Override
    public final boolean nsSensitive() {
        return false;
    }

    @Override
    public final String toString() {
        return new TokenBuilder(NSGlobal.prefix(this.name.uri())).add(58).add(this.name.string()).toString();
    }

    public static ListType find(QNm type) {
        ListType[] listTypeArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ListType tp = listTypeArray[n2];
            if (tp.name.eq(type)) {
                return tp;
            }
            ++n2;
        }
        return null;
    }
}

