/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;

public final class Num {
    private Num() {
    }

    public static byte[] newNum(int value) {
        int len = Num.length(value);
        byte[] array = new byte[4 + len];
        Num.set(array, value, 4, len);
        Num.size(array, 4 + len);
        return array;
    }

    public static byte[] num(int value) {
        int len = Num.length(value);
        byte[] array = new byte[len];
        Num.set(array, value, 0, len);
        return array;
    }

    public static byte[] add(byte[] array, int value) {
        int len = Num.length(value);
        int pos = Num.size(array);
        byte[] tmp = Num.check(array, pos, len);
        Num.set(tmp, value, pos, len);
        Num.size(tmp, pos + len);
        return tmp;
    }

    public static int get(byte[] array, int pos) {
        int p = pos;
        int v = array[p++] & 0xFF;
        switch ((v & 0xC0) >>> 6) {
            case 0: {
                return v;
            }
            case 1: {
                return (v & 0x3F) << 8 | array[p] & 0xFF;
            }
            case 2: {
                return (v & 0x3F) << 24 | (array[p++] & 0xFF) << 16 | (array[p++] & 0xFF) << 8 | array[p] & 0xFF;
            }
        }
        return (array[p++] & 0xFF) << 24 | (array[p++] & 0xFF) << 16 | (array[p++] & 0xFF) << 8 | array[p] & 0xFF;
    }

    public static int set(byte[] array, int value) {
        int l = Num.length(value);
        Num.set(array, value, 0, l);
        return l;
    }

    public static int size(byte[] array) {
        return ((array[0] & 0xFF) << 24) + ((array[1] & 0xFF) << 16) + ((array[2] & 0xFF) << 8) + (array[3] & 0xFF);
    }

    public static void size(byte[] array, int length) {
        array[0] = (byte)(length >>> 24);
        array[1] = (byte)(length >>> 16);
        array[2] = (byte)(length >>> 8);
        array[3] = (byte)length;
    }

    public static int length(byte[] array, int pos) {
        int v = (array[pos] & 0xFF) >>> 6;
        return v == 0 ? 1 : (v == 1 ? 2 : (v == 2 ? 4 : 5));
    }

    public static int length(int v) {
        return v < 0 || v > 0x3FFFFFFF ? 5 : (v > 16383 ? 4 : (v > 63 ? 2 : 1));
    }

    public static String toString(byte[] num) {
        StringBuilder sb = new StringBuilder();
        int pos = Num.size(num);
        int ip = 4;
        while (ip < pos) {
            if (ip > 4) {
                sb.append(',');
            }
            sb.append(Num.get(num, ip));
            ip += Num.length(num, ip);
        }
        return sb.toString();
    }

    private static byte[] check(byte[] a, int p, int l) {
        int s = a.length;
        return p + l < s ? a : Arrays.copyOf(a, s + Math.max(l, s >> 3));
    }

    private static void set(byte[] a, int v, int p, int l) {
        int i = p;
        if (l == 5) {
            a[i++] = -64;
            a[i++] = (byte)(v >>> 24);
            a[i++] = (byte)(v >>> 16);
            a[i++] = (byte)(v >>> 8);
        } else if (l == 4) {
            a[i++] = (byte)(v >>> 24 | 0x80);
            a[i++] = (byte)(v >>> 16);
            a[i++] = (byte)(v >>> 8);
        } else if (l == 2) {
            a[i++] = (byte)(v >>> 8 | 0x40);
        }
        a[i] = (byte)v;
    }
}

