/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.basex.core.BaseXException;
import org.basex.core.CLI;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.jobs.Jobs;
import org.basex.http.HTTPContext;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.server.Log;
import org.basex.util.Main;
import org.basex.util.MainParser;
import org.basex.util.Pair;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.Option;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public final class BaseXHTTP
extends CLI {
    private Server jetty;
    private int port;
    private String host;
    private int stopPort;
    private boolean service;
    private boolean quiet;
    private boolean stop;

    public static void main(String ... args) {
        try {
            new BaseXHTTP(args);
        }
        catch (Exception ex) {
            Util.errln((Object)ex, (Object[])new Object[0]);
            System.exit(1);
        }
    }

    public BaseXHTTP(String ... args) throws Exception {
        super(null, args);
        this.context = HTTPContext.context();
        for (Pair cmd : this.commands) {
            if (this.execute(cmd)) continue;
            return;
        }
        StaticOptions sopts = this.context.soptions;
        String webapp = sopts.get(StaticOptions.WEBPATH);
        WebAppContext wac = new WebAppContext(webapp, "/");
        this.jetty = (Server)new XmlConfiguration(BaseXHTTP.initJetty(webapp).inputStream()).configure();
        this.jetty.setHandler((Handler)wac);
        ArrayList<ServerConnector> conns = new ArrayList<ServerConnector>(1);
        Connector[] connectorArray = this.jetty.getConnectors();
        int n = connectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connector conn = connectorArray[n2];
            if (conn instanceof ServerConnector) {
                conns.add((ServerConnector)conn);
            }
            ++n2;
        }
        if (conns.isEmpty()) {
            throw new BaseXException("No Jetty connectors defined in WEB-INF/jetty.xml.", new Object[0]);
        }
        this.stopPort = sopts.get(StaticOptions.STOPPORT);
        this.host = sopts.get(StaticOptions.SERVERHOST);
        ServerConnector conn1 = (ServerConnector)conns.get(0);
        if (this.port != 0) {
            conn1.setPort(this.port);
        }
        String startX = "HTTP " + Text.SRV_STARTED_PORT_X;
        String stopX = "HTTP " + Text.SRV_STOPPED_PORT_X;
        if (this.stop) {
            this.stop();
            if (!this.quiet) {
                for (ServerConnector conn : conns) {
                    Util.outln((Object)stopX, (Object[])new Object[]{conn.getPort()});
                }
            }
            Performance.sleep((long)1000L);
            return;
        }
        if (this.service) {
            BaseXHTTP.start(args);
            if (!this.quiet) {
                for (ServerConnector conn : conns) {
                    Util.outln((Object)startX, (Object[])new Object[]{conn.getPort()});
                }
            }
            Performance.sleep((long)1000L);
            return;
        }
        if (!this.quiet) {
            Util.outln((Object)this.header(), (Object[])new Object[0]);
        }
        try {
            this.jetty.start();
        }
        catch (BindException ex) {
            Util.debug((Throwable)ex);
            throw new BaseXException("HTTP " + Text.SRV_RUNNING_X, new Object[]{conn1.getPort()});
        }
        IOException ex = HTTPContext.exception();
        if (ex != null) {
            throw ex;
        }
        if (!this.quiet) {
            for (ServerConnector conn : conns) {
                Util.outln((Object)startX, (Object[])new Object[]{conn.getPort()});
            }
        }
        HTTPContext.init((ServletContext)wac.getServletContext());
        if (this.stopPort > 0) {
            new StopServer().start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Log log;
            if (!this.quiet) {
                for (ServerConnector conn : conns) {
                    Util.outln((Object)stopX, (Object[])new Object[]{conn.getPort()});
                }
            }
            if ((log = this.context.log) != null) {
                for (ServerConnector conn : conns) {
                    log.writeServer(Log.LogType.OK, Util.info((Object)stopX, (Object[])new Object[]{conn.getPort()}));
                }
            }
            this.context.close();
        }));
        for (ServerConnector conn : conns) {
            this.context.log.writeServer(Log.LogType.OK, Util.info((Object)startX, (Object[])new Object[]{conn.getPort()}));
        }
        new Jobs(this.context).run();
    }

    public void stop() throws Exception {
        if (this.stopPort > 0) {
            BaseXHTTP.stop(this.host.isEmpty() ? "localhost" : this.host, this.stopPort);
        }
    }

    private static IOFile initJetty(String root) throws IOException {
        BaseXHTTP.locate("WEB-INF/web.xml", root);
        return BaseXHTTP.locate("WEB-INF/jetty.xml", root);
    }

    private static IOFile locate(String file, String root) throws IOException {
        byte[] data;
        boolean create;
        IOFile trg;
        block15: {
            trg = new IOFile(root, file);
            create = !trg.exists();
            IOFile in = new IOFile("src/main/webapp", file);
            if (in.exists()) {
                data = in.read();
                IOFile res = new IOFile("src/main/resources");
                if (!(!res.exists() || (res = new IOFile(res, file)).exists() && Token.eq((byte[])data, (byte[])res.read()))) {
                    Util.errln((Object)("Updating " + res), (Object[])new Object[0]);
                    res.parent().md();
                    res.write(in.read());
                }
            } else {
                if (create) {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (InputStream is = BaseXHTTP.class.getResourceAsStream(String.valueOf('/') + file);){
                        if (is == null) {
                            throw new BaseXException(in + " not found.", new Object[0]);
                        }
                        data = new IOStream(is).read();
                        break block15;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                return trg;
            }
        }
        if (create) {
            Util.errln((Object)("Creating " + trg), (Object[])new Object[0]);
            trg.parent().md();
            trg.write(data);
        }
        return trg;
    }

    protected void parseArgs() throws IOException {
        MainParser arg = new MainParser((Main)this);
        boolean daemon = true;
        block14: while (arg.more()) {
            if (arg.dash()) {
                switch (arg.next()) {
                    case 'c': {
                        this.commands.add(BaseXHTTP.input((String)arg.string()));
                        continue block14;
                    }
                    case 'd': {
                        Prop.put((Option)StaticOptions.DEBUG, (String)Boolean.toString(true));
                        Prop.debug = true;
                        continue block14;
                    }
                    case 'D': {
                        daemon = false;
                        continue block14;
                    }
                    case 'h': {
                        this.port = arg.number();
                        continue block14;
                    }
                    case 'l': {
                        Prop.put((Option)StaticOptions.HTTPLOCAL, (String)Boolean.toString(true));
                        continue block14;
                    }
                    case 'n': {
                        String n = arg.string();
                        Prop.put((Option)StaticOptions.HOST, (String)n);
                        Prop.put((Option)StaticOptions.SERVERHOST, (String)n);
                        continue block14;
                    }
                    case 'p': {
                        int p = arg.number();
                        Prop.put((Option)StaticOptions.PORT, (String)Integer.toString(p));
                        Prop.put((Option)StaticOptions.SERVERPORT, (String)Integer.toString(p));
                        continue block14;
                    }
                    case 'q': {
                        this.quiet = true;
                        continue block14;
                    }
                    case 's': {
                        Prop.put((Option)StaticOptions.STOPPORT, (String)Integer.toString(arg.number()));
                        continue block14;
                    }
                    case 'S': {
                        this.service = daemon;
                        continue block14;
                    }
                    case 'U': {
                        Prop.put((Option)StaticOptions.USER, (String)arg.string());
                        continue block14;
                    }
                    case 'z': {
                        Prop.put((Option)StaticOptions.LOG, (String)Boolean.toString(false));
                        continue block14;
                    }
                    default: {
                        throw arg.usage();
                    }
                }
            }
            if (!"stop".equalsIgnoreCase(arg.string())) {
                throw arg.usage();
            }
            this.stop = true;
        }
    }

    public static void start(String ... args) throws BaseXException {
        String error = Util.error((Process)Util.start(BaseXHTTP.class, (String[])args), (int)2000);
        if (error != null) {
            throw new BaseXException(error.trim(), new Object[0]);
        }
    }

    public static void stop(String host, int port) throws IOException {
        IOFile stopFile = BaseXHTTP.stopFile(BaseXHTTP.class, (int)port);
        stopFile.touch();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                Socket s = new Socket(host, port);
                if (s != null) {
                    s.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ConnectException ex) {
            Util.debug((Throwable)ex);
            stopFile.delete();
            throw new IOException(Util.info((Object)Text.CONNECTION_ERROR_X, (Object[])new Object[]{port}));
        }
        do {
            Performance.sleep((long)10L);
        } while (stopFile.exists());
    }

    public String header() {
        return Util.info((Object)Text.S_CONSOLE_X, (Object[])new Object[]{"HTTP Server"});
    }

    public String usage() {
        return Text.S_HTTPINFO;
    }

    private final class StopServer
    extends Thread {
        private final ServerSocket socket;
        private final IOFile stopFile;

        StopServer() throws IOException {
            InetAddress addr = BaseXHTTP.this.host.isEmpty() ? null : InetAddress.getByName(BaseXHTTP.this.host);
            this.socket = new ServerSocket();
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(addr, BaseXHTTP.this.stopPort));
            this.stopFile = BaseXHTTP.stopFile((Class)BaseXHTTP.class, (int)BaseXHTTP.this.stopPort);
        }

        @Override
        public void run() {
            try {
                do {
                    Util.outln((Object)("HTTP " + Text.STOP + ' ' + Text.SRV_STARTED_PORT_X), (Object[])new Object[]{BaseXHTTP.this.stopPort});
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try {
                        Socket s = this.socket.accept();
                        if (s == null) continue;
                        s.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                } while (!this.stopFile.exists());
                this.socket.close();
                Util.outln((Object)("HTTP " + Text.STOP + ' ' + Text.SRV_STOPPED_PORT_X), (Object[])new Object[]{BaseXHTTP.this.stopPort});
                BaseXHTTP.this.jetty.stop();
                HTTPContext.close();
                Prop.clear();
                if (!this.stopFile.delete()) {
                    BaseXHTTP.this.context.log.writeServer(Log.LogType.ERROR, Util.info((Object)Text.FILE_NOT_DELETED_X, (Object[])new Object[]{this.stopFile}));
                }
            }
            catch (Exception ex) {
                Util.stack((Throwable)ex);
            }
        }
    }
}

