/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqModule;
import org.basex.http.restxq.RestXqWadl;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.http.MediaType;

public final class RestXqModules {
    private static volatile RestXqModules instance;
    private final AtomicBoolean parsed = new AtomicBoolean();
    private final IOFile path;
    private final boolean cached;
    private HashMap<String, RestXqModule> modules = new HashMap();
    private long last;

    private RestXqModules(Context ctx) {
        StaticOptions sopts = ctx.soptions;
        String webpath = sopts.get(StaticOptions.WEBPATH);
        String rxqpath = sopts.get(StaticOptions.RESTXQPATH);
        this.path = new IOFile(webpath).resolve(rxqpath);
        final int ms = sopts.get(StaticOptions.PARSERESTXQ) * 1000;
        boolean bl = this.cached = ms != 0;
        if (ms >= 0) {
            new Timer(true).scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (System.currentTimeMillis() - RestXqModules.this.last >= (long)ms) {
                        RestXqModules.this.init();
                    }
                }
            }, 0L, 500L);
        }
    }

    public static RestXqModules get(Context ctx) {
        if (instance == null) {
            instance = new RestXqModules(ctx);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        AtomicBoolean atomicBoolean = this.parsed;
        synchronized (atomicBoolean) {
            this.parsed.set(false);
        }
    }

    public FElem wadl(HTTPConnection conn) {
        return new RestXqWadl(conn).create(this.modules);
    }

    RestXqFunction find(HTTPConnection conn, QNm error) throws Exception {
        List<RestXqFunction> funcs = this.find(conn, error, false);
        if (funcs.isEmpty()) {
            return null;
        }
        RestXqFunction first = funcs.get(0);
        int l = funcs.size() - 1;
        while (l > 0) {
            if (first.compareTo(funcs.get(l)) != 0) {
                funcs.remove(l);
            }
            --l;
        }
        if (funcs.size() == 1) {
            return first;
        }
        if ((funcs = RestXqModules.bestQf(funcs, conn)).size() == 1) {
            return funcs.get(0);
        }
        TokenBuilder tb = new TokenBuilder();
        for (RestXqFunction func : funcs) {
            tb.add(Text.NL).add("- ").addExt((Object)func.function.name.prefixString(), new Object[0]);
            if (func.produces.isEmpty()) continue;
            tb.add(" ").addExt(func.produces, new Object[0]);
        }
        throw first.path == null ? first.error("Several functions found for error \"%\":%", error, tb) : first.error("Several functions found for path \"%\":%", first.path, tb);
    }

    List<RestXqFunction> checks(HTTPConnection conn) throws Exception {
        return this.find(conn, null, true);
    }

    private List<RestXqFunction> find(HTTPConnection conn, QNm error, boolean perm) throws Exception {
        ArrayList<RestXqFunction> list = new ArrayList<RestXqFunction>();
        for (RestXqModule mod : this.cache(conn.context).values()) {
            for (RestXqFunction func : mod.functions()) {
                if (!func.matches(conn, error, perm)) continue;
                list.add(func);
            }
        }
        Collections.sort(list);
        return list;
    }

    private static List<RestXqFunction> bestQf(List<RestXqFunction> funcs, HTTPConnection conn) {
        MediaType[] accepts = conn.accepts();
        double cQf = 0.0;
        double sQf = 0.0;
        for (RestXqFunction func : funcs) {
            MediaType[] mediaTypeArray = accepts;
            int n = accepts.length;
            int n2 = 0;
            while (n2 < n) {
                MediaType accept = mediaTypeArray[n2];
                if (func.produces.isEmpty()) {
                    cQf = Math.max(cQf, RestXqModules.qf(accept, "q"));
                    sQf = 1.0;
                } else {
                    for (MediaType produce : func.produces) {
                        if (!produce.matches(accept)) continue;
                        cQf = Math.max(cQf, RestXqModules.qf(accept, "q"));
                        sQf = Math.max(sQf, RestXqModules.qf(produce, "qs"));
                    }
                }
                ++n2;
            }
        }
        List<RestXqFunction> list = RestXqModules.bestQf(funcs, accepts, cQf, -1.0);
        return list.size() > 1 ? RestXqModules.bestQf(funcs, accepts, cQf, sQf) : list;
    }

    private static List<RestXqFunction> bestQf(List<RestXqFunction> funcs, MediaType[] accepts, double clientQf, double serverQf) {
        ArrayList<RestXqFunction> list = new ArrayList<RestXqFunction>();
        for (RestXqFunction func : funcs) {
            BooleanSupplier s = () -> {
                MediaType[] mediaTypeArray2 = accepts;
                int n = accepts.length;
                int n2 = 0;
                while (n2 < n) {
                    MediaType accept = mediaTypeArray2[n2];
                    if (restXqFunction.produces.isEmpty()) {
                        if (RestXqModules.qf(accept, "q") == clientQf) {
                            return true;
                        }
                    } else {
                        for (MediaType produce : restXqFunction.produces) {
                            if (!produce.matches(accept) || RestXqModules.qf(accept, "q") != clientQf || serverQf != -1.0 && RestXqModules.qf(produce, "qs") != serverQf) continue;
                            return true;
                        }
                    }
                    ++n2;
                }
                return false;
            };
            if (!s.getAsBoolean()) continue;
            list.add(func);
        }
        return list;
    }

    private static double qf(MediaType mt, String f) {
        String qf = (String)mt.parameters().get(f);
        return qf != null ? Token.toDouble((byte[])Token.token((String)qf)) : 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, RestXqModule> cache(Context ctx) throws Exception {
        AtomicBoolean atomicBoolean = this.parsed;
        synchronized (atomicBoolean) {
            if (!this.parsed.get()) {
                if (!this.path.exists()) {
                    throw HTTPCode.NO_RESTXQ.get(new Object[0]);
                }
                HashMap<String, RestXqModule> map = new HashMap<String, RestXqModule>();
                RestXqModules.cache(ctx, this.path, map, this.modules);
                this.modules = map;
                this.parsed.set(this.cached);
            }
            this.last = System.currentTimeMillis();
            return this.modules;
        }
    }

    private static void cache(Context ctx, IOFile root, HashMap<String, RestXqModule> cache, HashMap<String, RestXqModule> old) throws Exception {
        IOFile file;
        IOFile[] files;
        IOFile[] iOFileArray = files = root.children();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            file = iOFileArray[n2];
            if (file.name().equals(".ignore")) {
                return;
            }
            ++n2;
        }
        iOFileArray = files;
        n = files.length;
        n2 = 0;
        while (n2 < n) {
            file = iOFileArray[n2];
            if (file.isDir()) {
                RestXqModules.cache(ctx, file, cache, old);
            } else {
                String path = file.path();
                if (file.hasSuffix(IO.XQSUFFIXES)) {
                    RestXqModule module = old.get(path);
                    boolean parsed = false;
                    if (module != null) {
                        parsed = module.uptodate();
                    } else {
                        module = new RestXqModule(file);
                    }
                    if (parsed || module.parse(ctx)) {
                        module.touch();
                        cache.put(path, module);
                    }
                }
            }
            ++n2;
        }
    }
}

