/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqSingleton;
import org.basex.http.restxq.RestXqText;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.StaticFunc;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.scope.MainModule;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.http.HttpMethod;

final class RestXqResponse {
    private final RestXqFunction func;
    private final QueryContext qc;
    private final HTTPConnection conn;
    private OutputStream out;
    private String message;
    private Integer status;

    RestXqResponse(RestXqFunction func, QueryContext qc, HTTPConnection conn) {
        this.func = func;
        this.qc = qc;
        this.conn = conn;
    }

    boolean create(Object ext) throws Exception {
        boolean bl;
        StaticFunc sf = this.func.function;
        Expr[] args = new Expr[sf.params.length];
        this.func.bind(this.conn, args, ext, this.qc);
        this.qc.mainModule(MainModule.get((StaticFunc)sf, (Expr[])args));
        this.qc.http((Object)this.conn);
        this.qc.jc().type("RESTXQ");
        String sngl = this.func.singleton;
        RestXqSingleton singleton = sngl != null ? new RestXqSingleton(this.conn, sngl, this.qc) : null;
        String redirect = null;
        String forward = null;
        this.qc.register(this.qc.context);
        try {
            Iter iter = this.qc.iter();
            Item first = iter.next();
            if (first instanceof ANode) {
                ANode node = (ANode)first;
                if (RestXqText.REST_REDIRECT.eq(node)) {
                    ANode ch = node.children().next();
                    if (ch == null || ch.type != NodeType.TXT) {
                        throw this.func.error("'%' element has no string value.", new Object[]{node.name()});
                    }
                    redirect = Token.string((byte[])ch.string()).trim();
                } else if (RestXqText.REST_FORWARD.eq(node)) {
                    ANode ch = node.children().next();
                    if (ch == null || ch.type != NodeType.TXT) {
                        throw this.func.error("'%' element has no string value.", new Object[]{node.name()});
                    }
                    forward = Token.string((byte[])ch.string()).trim();
                } else if (RestXqText.REST_RESPONSE.eq(node)) {
                    this.build(node, iter);
                } else {
                    this.serialize(first, iter, false);
                }
            } else {
                this.serialize(first, iter, singleton != null);
            }
            bl = first == null;
        }
        catch (Throwable throwable) {
            this.qc.close();
            this.qc.unregister(this.qc.context);
            if (singleton != null) {
                singleton.unregister();
            }
            if (redirect != null) {
                this.conn.redirect(redirect);
            } else if (forward != null) {
                this.conn.forward(forward);
            } else {
                this.qc.checkStop();
                this.finish();
            }
            throw throwable;
        }
        this.qc.close();
        this.qc.unregister(this.qc.context);
        if (singleton != null) {
            singleton.unregister();
        }
        if (redirect != null) {
            this.conn.redirect(redirect);
        } else if (forward != null) {
            this.conn.forward(forward);
        } else {
            this.qc.checkStop();
            this.finish();
        }
        return bl;
    }

    private void build(ANode response, Iter iter) throws Exception {
        Item first;
        BasicNodeIter atts = response.attributes();
        ANode attr = atts.next();
        if (attr != null) {
            throw this.func.error("Unexpected node: %.", attr);
        }
        SerializerOptions sp = this.func.output;
        String cType = null;
        for (ANode n : response.children()) {
            if (RestXqText.HTTP_RESPONSE.eq(n)) {
                byte[] sta = null;
                byte[] msg = null;
                for (ANode a : n.attributes()) {
                    QNm qnm = a.qname();
                    if (qnm.eq(RestXqText.Q_STATUS)) {
                        sta = a.string();
                        continue;
                    }
                    if (qnm.eq(RestXqText.Q_REASON) || qnm.eq(RestXqText.Q_MESSAGE)) {
                        msg = a.string();
                        continue;
                    }
                    throw this.func.error("Unexpected node: %.", a);
                }
                if (sta != null) {
                    this.status = Token.toInt(sta);
                    this.message = msg != null ? Token.string(msg) : null;
                }
                for (ANode c : n.children()) {
                    if (RestXqText.HTTP_HEADER.eq(c)) {
                        byte[] nam = c.attribute(RestXqText.Q_NAME);
                        byte[] val = c.attribute(RestXqText.Q_VALUE);
                        if (nam == null || val == null) continue;
                        String key = Token.string((byte[])nam);
                        String value = Token.string((byte[])val);
                        if (key.equalsIgnoreCase("Content-Type")) {
                            cType = value;
                            continue;
                        }
                        this.conn.res.setHeader(key, key.equalsIgnoreCase("Location") ? this.conn.resolve(value) : value);
                        continue;
                    }
                    throw this.func.error("Unexpected node: %.", c);
                }
                continue;
            }
            if (RestXqText.OUTPUT_SERIAL.eq(n)) {
                sp = FuncOptions.serializer((Item)n, (SerializerOptions)this.func.output, (InputInfo)this.func.function.info);
                continue;
            }
            throw this.func.error("Unexpected node: %.", n);
        }
        if (cType != null) {
            sp.set(SerializerOptions.MEDIA_TYPE, cType);
        }
        if ((first = iter.next()) != null) {
            this.checkHead();
        }
        this.serialize(first, iter, sp, true);
    }

    private void serialize(Item first, Iter iter, boolean cache) throws Exception {
        this.checkHead();
        this.serialize(first, iter, this.func.output, cache);
    }

    private void serialize(Item first, Iter iter, SerializerOptions sp, boolean cache) throws Exception {
        this.conn.sopts(sp);
        this.conn.initResponse();
        this.out = cache ? new ArrayOutput() : this.conn.res.getOutputStream();
        Item item = first;
        Throwable throwable = null;
        Object var7_8 = null;
        try (Serializer ser = Serializer.get((OutputStream)this.out, (SerializerOptions)sp);){
            while (item != null) {
                ser.serialize(item);
                item = this.qc.next(iter);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void checkHead() throws QueryException {
        if (this.func.methods.size() == 1 && this.func.methods.contains(HttpMethod.HEAD.name())) {
            throw this.func.error("HEAD method must return a single 'restxq:response' element.", new Object[0]);
        }
    }

    private void finish() throws IOException {
        ArrayOutput ao;
        if (this.status != null) {
            this.conn.status(this.status, this.message);
        }
        if (this.out instanceof ArrayOutput && (ao = (ArrayOutput)this.out).size() > 0L) {
            this.conn.res.getOutputStream().write(ao.finish());
        }
    }
}

