/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.jobs.Job;
import org.basex.core.jobs.JobContext;
import org.basex.core.jobs.JobPool;
import org.basex.core.jobs.QueryJobResult;
import org.basex.core.jobs.QueryJobTask;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dtm;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class JobsList
extends Command {
    public JobsList() {
        super(Perm.ADMIN, new String[0]);
    }

    @Override
    protected boolean run() throws IOException {
        Table table = new Table();
        table.description = Text.JOBS_X;
        table.header.add(Token.uc(Token.ID));
        table.header.add(Text.TYPE);
        table.header.add(Text.STATE);
        table.header.add(Text.USER);
        table.header.add(Text.DURATION);
        table.header.add(Text.START);
        table.header.add(Text.END);
        table.header.add(Text.READS);
        table.header.add(Text.WRITES);
        JobPool jobs = this.context.jobs;
        for (byte[] key : JobsList.ids(this.context)) {
            TokenList entry = JobsList.entry(key, jobs, 0);
            if (entry == null) continue;
            table.contents.add(entry);
        }
        this.out.println(table.sort().finish());
        return true;
    }

    public static TokenList ids(Context ctx) {
        JobPool jobs = ctx.jobs;
        HashSet<String> set = new HashSet<String>();
        set.addAll(jobs.results.keySet());
        set.addAll(jobs.active.keySet());
        set.addAll(jobs.tasks.keySet());
        TokenList list = new TokenList(set.size());
        for (String id : set) {
            list.add(id);
        }
        return JobsList.sort(list);
    }

    public static TokenList entry(byte[] key, JobPool jobs, int max) {
        String id = Token.string(key);
        Job job = jobs.active.get(id);
        QueryJobTask jt = jobs.tasks.get(id);
        QueryJobResult jr = jobs.results.get(id);
        if (job == null && jr != null) {
            job = jr.job;
        }
        if (job == null && jt != null) {
            job = jt.job;
        }
        if (job == null) {
            return null;
        }
        JobContext jc = job.jc();
        long ms = jc.performance != null ? (System.nanoTime() - jc.performance.start()) / 1000000L : (jr != null ? jr.time / 1000000L : -1L);
        TokenList tl = new TokenList(10);
        tl.add(id);
        tl.add(jc.type());
        tl.add(job.state.toString().toLowerCase(Locale.ENGLISH));
        tl.add(jc.context.clientName());
        tl.add(ms >= 0L ? DTDur.get(ms).string(null) : Token.EMPTY);
        tl.add(jt != null ? Dtm.get(jt.start).string(null) : Token.EMPTY);
        tl.add(jt != null && jt.end != Long.MAX_VALUE ? Dtm.get(jt.end).string(null) : Token.EMPTY);
        tl.add(jc.locks.reads.toString());
        tl.add(jc.locks.writes.toString());
        tl.add(Token.chop(Token.normalize(Token.token(jc.toString())), max));
        return tl;
    }

    private static TokenList sort(TokenList list) {
        return (TokenList)list.sort((token1, token2) -> {
            byte[] id1 = Token.substring(token1, 3);
            byte[] id2 = Token.substring(token2, 3);
            long diff = Token.toLong(id1) - Token.toLong(id2);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }, true);
    }

    @Override
    public void addLocks() {
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.JOBS) + " " + (Object)((Object)Commands.CmdJobs.LIST)).args();
    }
}

