/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import java.util.Stack;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.QueryError;
import org.basex.query.QueryIOException;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTxt;
import org.basex.util.Util;
import org.basex.util.XMLToken;

final class JsonMLConverter
extends JsonXmlConverter {
    private final Stack<FElem> stack = new Stack();
    private byte[] attName;

    JsonMLConverter(JsonParserOptions opts) {
        super(opts);
    }

    @Override
    public FDoc finish() {
        return new FDoc().add(this.stack.pop());
    }

    private static void error(String msg, Object ... ext) throws QueryIOException {
        throw QueryError.JSON_PARSE_X.getIO(new Object[]{Util.inf(msg, ext)});
    }

    private static byte[] check(byte[] name) throws QueryIOException {
        if (!XMLToken.isNCName(name)) {
            JsonMLConverter.error("Invalid name: \"%\"", new Object[]{name});
        }
        return name;
    }

    @Override
    public void openObject() throws QueryIOException {
        if (this.curr == null || this.attName != null || this.stack.peek() != null) {
            JsonMLConverter.error("No object allowed at this stage", new Object[0]);
        }
    }

    @Override
    public void openPair(byte[] key, boolean add) throws QueryIOException {
        this.attName = JsonMLConverter.check(key);
    }

    @Override
    public void closePair(boolean add) {
    }

    @Override
    public void closeObject() {
        this.stack.pop();
        this.stack.push(this.curr);
        this.curr = null;
    }

    @Override
    public void openArray() throws QueryIOException {
        if (!this.stack.isEmpty()) {
            if (this.attName == null && this.curr != null && this.stack.peek() == null) {
                this.stack.pop();
                this.stack.push(this.curr);
                this.curr = null;
            } else if (this.attName != null || this.curr != null || this.stack.peek() == null) {
                JsonMLConverter.error("No array allowed at this stage", new Object[0]);
            }
        }
        this.stack.push(null);
        this.curr = null;
    }

    @Override
    public void openItem() {
    }

    @Override
    public void closeItem() {
    }

    @Override
    public void closeArray() throws QueryIOException {
        FElem val = this.stack.pop();
        if (val == null) {
            val = this.curr;
            this.curr = null;
        }
        if (val == null) {
            JsonMLConverter.error("Missing element name", new Object[0]);
        }
        if (this.stack.isEmpty()) {
            this.stack.push(val);
        } else {
            this.stack.peek().add(val);
        }
    }

    @Override
    public void stringLit(byte[] value) throws QueryIOException {
        if (this.attName == null && this.curr != null && this.stack.peek() == null) {
            this.stack.pop();
            this.stack.push(this.curr);
            this.curr = null;
        }
        if (this.curr == null) {
            FElem elem;
            FElem fElem = elem = this.stack.isEmpty() ? null : this.stack.peek();
            if (elem == null) {
                this.curr = new FElem(JsonMLConverter.check(value));
            } else {
                elem.add(new FTxt(value));
            }
        } else if (this.attName != null) {
            this.curr.add(this.attName, value);
            this.attName = null;
        } else {
            JsonMLConverter.error("No string allowed at this stage", new Object[0]);
        }
    }

    @Override
    public void numberLit(byte[] value) throws QueryIOException {
        JsonMLConverter.error("No numbers allowed", new Object[0]);
    }

    @Override
    public void nullLit() throws QueryIOException {
        JsonMLConverter.error("No 'null' allowed", new Object[0]);
    }

    @Override
    public void booleanLit(byte[] b) throws QueryIOException {
        JsonMLConverter.error("No booleans allowed", new Object[0]);
    }
}

