/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Castable
extends Single {
    private final StaticContext sc;
    private final SeqType castType;

    public Castable(StaticContext sc, InputInfo info, Expr expr, SeqType castType) {
        super(info, expr, SeqType.BLN_O);
        this.sc = sc;
        this.castType = castType;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        return this.expr.seqType().instanceOf(this.castType) ? cc.replaceWith(this, Bln.TRUE) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Value value = this.expr.value(qc);
        return Bln.get(this.castType.occ.check(value.size()) && (value.isEmpty() || this.castType.cast((Item)value, qc, this.sc, this.info, false) != null));
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new Castable(this.sc, this.info, this.expr.copy(cc, vm), this.castType);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Castable && this.castType.eq(((Castable)obj).castType) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        Castable.addPlan(plan, this.planElem("as", this.castType), this.expr);
    }

    @Override
    public String toString() {
        return this.expr + " " + "castable" + ' ' + "as" + ' ' + this.castType;
    }
}

