/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.EnumMap;
import org.basex.data.MetaData;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.ft.ThesQuery;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.Language;
import org.basex.util.ft.StemDir;
import org.basex.util.ft.StopWords;

public final class FTOpt
extends ExprInfo {
    private final EnumMap<FTFlag, Boolean> map = new EnumMap(FTFlag.class);
    public FTCase cs;
    public StemDir sd;
    public StopWords sw;
    public ThesQuery th;
    public Language ln;

    public FTOpt assign(FTOpt opt) {
        opt.map.forEach((key, value) -> this.map.computeIfAbsent((FTFlag)((Object)key), k -> value));
        if (this.cs == null) {
            this.cs = opt.cs;
        }
        if (this.sw == null) {
            this.sw = opt.sw;
        }
        if (this.sd == null) {
            this.sd = opt.sd;
        }
        if (this.ln == null) {
            this.ln = opt.ln;
        }
        if (this.th == null) {
            this.th = opt.th;
        } else if (opt.th != null) {
            this.th.merge(opt.th);
        }
        return this;
    }

    public FTOpt assign(MetaData md) {
        this.set(FTFlag.DC, md.diacritics);
        this.set(FTFlag.ST, md.stemming);
        this.cs = md.casesens ? FTCase.SENSITIVE : FTCase.INSENSITIVE;
        this.ln = md.language;
        return this;
    }

    public void set(FTFlag flag, boolean value) {
        this.map.put(flag, value);
    }

    public boolean isSet(FTFlag flag) {
        return this.map.containsKey((Object)flag);
    }

    public boolean is(FTFlag flag) {
        Boolean b = this.map.get((Object)flag);
        return b != null && b != false;
    }

    @Override
    public void plan(FElem plan) {
        if (this.is(FTFlag.WC)) {
            plan.add(FTOpt.planAttr("wildcards", Token.TRUE));
        }
        if (this.is(FTFlag.FZ)) {
            plan.add(FTOpt.planAttr("fuzzy", Token.TRUE));
        }
        if (this.cs != FTCase.INSENSITIVE) {
            plan.add(FTOpt.planAttr("case", (Object)this.cs));
        }
        if (this.is(FTFlag.DC)) {
            plan.add(FTOpt.planAttr("diacritics", Token.TRUE));
        }
        if (this.is(FTFlag.ST)) {
            plan.add(FTOpt.planAttr("stemming", Token.TRUE));
        }
        if (this.ln != null) {
            plan.add(FTOpt.planAttr("language", this.ln));
        }
        if (this.th != null) {
            plan.add(FTOpt.planAttr("thesaurus", Token.TRUE));
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.is(FTFlag.WC)) {
            s.append(" using wildcards");
        }
        if (this.is(FTFlag.FZ)) {
            s.append(" using fuzzy");
        }
        if (this.cs == FTCase.LOWER) {
            s.append(" using lowercase");
        } else if (this.cs == FTCase.UPPER) {
            s.append(" using uppercase");
        } else if (this.cs == FTCase.SENSITIVE) {
            s.append(" using case sensitive");
        }
        if (this.is(FTFlag.DC)) {
            s.append(" using diacritics sensitive");
        }
        if (this.is(FTFlag.ST) || this.sd != null) {
            s.append(" using stemming");
        }
        if (this.ln != null) {
            s.append(" using language '").append(this.ln).append('\'');
        }
        if (this.th != null) {
            s.append(" using thesaurus");
        }
        return s.toString();
    }
}

