/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Component;
import java.io.IOException;
import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.dialog.DialogParser;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.TextPanel;
import org.basex.io.IOContent;
import org.basex.io.parse.json.JsonConverter;
import org.basex.util.list.StringList;

final class DialogJsonParser
extends DialogParser {
    private static final String EXAMPLE = "{ \"Person\": \"John\\nAdam\",\n  \"Born\"  : 1984,\n  \"X?_\"  : [ true, null ] }";
    private static final String EXAMPLEML = "[ \"Person\",\n  { \"born\": \"1984\" },\n  \"John\\nAdam\"\n]";
    private final JsonParserOptions jopts;
    private final TextPanel example;
    private final BaseXCombo encoding;
    private final BaseXCombo format;
    private final BaseXCheckBox liberal;
    private final BaseXCheckBox escape;
    private final BaseXCheckBox lax;
    private final BaseXCheckBox merge;
    private final BaseXCheckBox strings;

    DialogJsonParser(BaseXDialog dialog, MainOptions opts) {
        this.jopts = new JsonParserOptions(opts.get(MainOptions.JSONPARSER));
        this.encoding = DialogJsonParser.encoding(dialog, this.jopts.get(JsonParserOptions.ENCODING));
        JsonOptions.JsonFormat[] formats = JsonOptions.JsonFormat.values();
        int fl = formats.length - 1;
        StringList frmts = new StringList(fl);
        for (int f = 0; f < fl; ++f) {
            frmts.add(formats[f].toString());
        }
        this.format = new BaseXCombo((BaseXWindow)dialog, (String[])frmts.finish());
        this.format.setSelectedItem((Object)this.jopts.get(JsonOptions.FORMAT));
        this.liberal = new BaseXCheckBox(dialog, Text.LIBERAL_PARSING, JsonParserOptions.LIBERAL, this.jopts);
        this.escape = new BaseXCheckBox(dialog, Text.ESCAPE_CHARS, JsonParserOptions.ESCAPE, this.jopts);
        this.merge = new BaseXCheckBox(dialog, Text.MERGE_TYPES, JsonOptions.MERGE, this.jopts);
        this.strings = new BaseXCheckBox(dialog, Text.INCLUDE_STRINGS, JsonOptions.STRINGS, this.jopts);
        this.lax = new BaseXCheckBox(dialog, Text.LAX_NAME_CONVERSION, JsonOptions.LAX, this.jopts);
        BaseXBack pp = new BaseXBack(new TableLayout(2, 1, 0, 8));
        BaseXBack p = new BaseXBack(new TableLayout(2, 2, 8, 4));
        p.add(new BaseXLabel(Text.ENCODING + ":", true, true));
        p.add(this.encoding);
        p.add(new BaseXLabel(Text.FORMAT + ":", true, true));
        p.add(this.format);
        pp.add(p);
        p = new BaseXBack(new TableLayout(5, 1));
        p.add(this.liberal);
        p.add(this.escape);
        p.add(this.merge);
        p.add(this.strings);
        p.add(this.lax);
        pp.add(p);
        this.add((Component)pp, "West");
        this.example = new TextPanel(dialog, false);
        this.add((Component)this.example, "Center");
        this.action(true);
    }

    @Override
    boolean action(boolean active) {
        try {
            boolean jl = this.jopts.get(JsonParserOptions.LIBERAL);
            JsonOptions.JsonFormat jf = this.jopts.get(JsonOptions.FORMAT);
            this.lax.setEnabled(jf == JsonOptions.JsonFormat.DIRECT);
            this.merge.setEnabled(jf != JsonOptions.JsonFormat.JSONML);
            this.strings.setEnabled(jf != JsonOptions.JsonFormat.JSONML);
            if (active) {
                String json = jf == JsonOptions.JsonFormat.JSONML ? EXAMPLEML : (jl ? EXAMPLE.replace("\"Person\"", "Person").replace(" }", ", }") : EXAMPLE);
                this.example.setText(DialogJsonParser.example(MainOptions.MainParser.JSON.name(), json, JsonConverter.get(this.jopts).convert(new IOContent(json)).serialize().toString()));
            }
        }
        catch (IOException ex) {
            this.example.setText(DialogJsonParser.error(ex));
        }
        return true;
    }

    @Override
    void update() {
        String enc = this.encoding.getSelectedItem();
        this.jopts.set(JsonParserOptions.ENCODING, enc.equals("UTF-8") ? null : enc);
        this.jopts.set(JsonParserOptions.LIBERAL, this.liberal.isSelected());
        this.jopts.set(JsonParserOptions.ESCAPE, this.escape.isSelected());
        this.jopts.set(JsonOptions.MERGE, this.merge.isSelected());
        this.jopts.set(JsonOptions.STRINGS, this.strings.isSelected());
        this.jopts.set(JsonOptions.FORMAT, this.format.getSelectedItem());
        this.jopts.set(JsonOptions.LAX, this.lax.isSelected());
    }

    @Override
    void setOptions(GUI gui) {
        gui.set(MainOptions.JSONPARSER, this.jopts);
    }
}

