/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.Rename;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIPopupCmd;
import org.basex.gui.dialog.DialogInput;
import org.basex.gui.dialog.DialogProgress;
import org.basex.gui.dialog.DialogProps;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXImages;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXTree;
import org.basex.gui.layout.ResourceFolder;
import org.basex.gui.layout.ResourceLeaf;
import org.basex.gui.layout.ResourceNode;
import org.basex.gui.layout.ResourceRootFolder;
import org.basex.util.Token;

final class DialogResources
extends BaseXBack {
    private final BaseXTextField filterText;
    private final ResourceFolder root;
    private final BaseXDialog dialog;
    private final BaseXTree tree;
    private final BaseXButton filter;
    private final BaseXButton clear;
    private boolean filtered;

    DialogResources(DialogProps dialog) {
        this.setLayout(new BorderLayout(0, 5));
        this.dialog = dialog;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.tree = new BaseXTree(dialog, rootNode).border(4, 4, 4, 4);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        this.tree.setCellRenderer(new TreeNodeRenderer());
        Context context = dialog.gui.context;
        Data data = context.data();
        String label = data.meta.name + " (/)";
        this.root = new ResourceRootFolder(Token.token(label), Token.token("/"), this.tree, context);
        ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(this.root, rootNode, 0);
        this.filter = new BaseXButton(dialog, Text.FILTER);
        this.clear = new BaseXButton(dialog, Text.CLEAR);
        this.filter.setEnabled(false);
        this.clear.setEnabled(false);
        new BaseXPopup(this.tree, dialog.gui, new DeleteCmd(), new RenameCmd());
        BaseXBack buttons = new BaseXBack();
        buttons.add(this.filter);
        buttons.add(this.clear);
        BaseXBack btn = new BaseXBack().layout(new BorderLayout());
        btn.add((Component)buttons, "East");
        this.filterText = new BaseXTextField(dialog, Text.PLEASE_WAIT_D);
        this.filterText.setEnabled(false);
        BaseXLayout.setWidth(this.filterText, 250);
        BaseXBack panel = new BaseXBack(new BorderLayout());
        panel.add((Component)this.filterText, "Center");
        panel.add((Component)btn, "South");
        JScrollPane sp = new JScrollPane(this.tree);
        BaseXLayout.setWidth(sp, 250);
        this.add((Component)sp, "Center");
        this.add((Component)panel, "South");
        this.tree.addTreeSelectionListener(e -> {
            ResourceNode n = (ResourceNode)e.getPath().getLastPathComponent();
            String filt = n.equals(this.root) ? "" : n.path();
            String trgt = filt + '/';
            if (n.isLeaf()) {
                n = (ResourceNode)n.getParent();
                trgt = (n == null || n.equals(this.root) ? "" : n.path()) + '/';
            } else {
                filt = trgt;
            }
            this.filterText.setText(filt);
            dialog.addPanel.target.setText(trgt);
            this.filtered = false;
        });
        new Thread(() -> {
            this.tree.setCursor(GUIConstants.CURSORWAIT);
            this.tree.expandPath(new TreePath(this.root.getPath()));
            this.filterText.setText("/");
            this.filterText.setEnabled(true);
            this.tree.setCursor(GUIConstants.CURSORARROW);
            this.filter.setEnabled(true);
            this.clear.setEnabled(true);
        }).start();
    }

    private ResourceNode selection() {
        TreePath t = this.tree.getSelectionPath();
        return t == null ? null : (ResourceNode)t.getLastPathComponent();
    }

    private void refreshFolder(ResourceFolder n) {
        if (n == null) {
            return;
        }
        n.removeChildren();
        TreePath path = new TreePath(n.getPath());
        this.tree.collapsePath(path);
        this.tree.expandPath(path);
    }

    void action(Object comp) {
        if (comp == this.filter && !this.filtered) {
            this.filter();
            this.filtered = true;
        } else if (comp == this.clear) {
            this.filterText.setText("/");
            this.filterText.requestFocusInWindow();
            this.refreshFolder(this.root);
            this.filtered = false;
        } else {
            this.tree.repaint();
        }
    }

    private void filter() {
        byte[] filterPath = ResourceNode.preparePath(Token.token(this.filterText.getText()));
        if (Token.eq(filterPath, Token.SLASH)) {
            this.refreshFolder(this.root);
            return;
        }
        Context context = this.dialog.gui.context;
        Data data = context.data();
        this.root.removeAllChildren();
        int cmax = 10000;
        if (data.resources.isDir(filterPath)) {
            this.root.add(new ResourceFolder(ResourceFolder.name(filterPath), ResourceFolder.path(filterPath), this.tree, context));
            --cmax;
        }
        byte[] name = ResourceFolder.name(filterPath);
        byte[] sub = ResourceFolder.path(filterPath);
        cmax = new ResourceFolder(ResourceFolder.name(sub), ResourceFolder.path(sub), this.tree, context).addLeaves(name, cmax, this.root);
        if (cmax <= 0) {
            this.root.add(new ResourceLeaf(Token.token("..."), sub, false, true, this.tree, context));
        }
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.root);
    }

    void refreshNewFolder(String p) {
        byte[][] pathComp = Token.split(Token.token(p), 47);
        ResourceNode n = this.root;
        block0: for (byte[] c : pathComp) {
            if (n instanceof ResourceFolder) {
                n.reload();
            }
            for (int i = 0; i < n.getChildCount(); ++i) {
                ResourceNode ch = (ResourceNode)n.getChildAt(i);
                if (!Token.eq(ch.name, c)) continue;
                n = ch;
                continue block0;
            }
        }
        this.refreshFolder((ResourceFolder)(n instanceof ResourceFolder ? n : n.getParent()));
    }

    private final class RenameCmd
    extends GUIPopupCmd {
        RenameCmd() {
            super(Text.RENAME + "...", BaseXKeys.RENAME);
        }

        @Override
        public void execute() {
            ResourceNode n = DialogResources.this.selection();
            if (n == null) {
                return;
            }
            DialogInput d = new DialogInput(n.path(), Text.RENAME, DialogResources.this.dialog, 0);
            if (!d.ok()) {
                return;
            }
            String p = Token.string(ResourceNode.preparePath(Token.token(d.input())));
            Runnable run = () -> DialogResources.this.refreshNewFolder(p);
            DialogProgress.execute(DialogResources.this.dialog, run, new Rename(n.path(), p));
        }

        @Override
        public boolean enabled(GUI main) {
            ResourceNode n = DialogResources.this.selection();
            return n instanceof ResourceLeaf ? !((ResourceLeaf)n).abbr : n != null && !n.equals(DialogResources.this.root);
        }
    }

    private final class DeleteCmd
    extends GUIPopupCmd {
        DeleteCmd() {
            super(Text.DELETE + "...", BaseXKeys.DELNEXT);
        }

        @Override
        public void execute() {
            ResourceNode n = DialogResources.this.selection();
            if (n == null || !BaseXDialog.confirm(((DialogResources)DialogResources.this).dialog.gui, Text.DELETE_NODES)) {
                return;
            }
            Runnable run = () -> DialogResources.this.refreshNewFolder(n.path());
            DialogProgress.execute(DialogResources.this.dialog, run, new Delete(n.path()));
        }

        @Override
        public boolean enabled(GUI main) {
            ResourceNode n = DialogResources.this.selection();
            return n instanceof ResourceLeaf ? !((ResourceLeaf)n).abbr : n != null && !n.equals(DialogResources.this.root);
        }
    }

    private static final class TreeNodeRenderer
    extends DefaultTreeCellRenderer {
        private TreeNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object val, boolean sel, boolean exp, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, val, sel, exp, leaf, row, focus);
            if (leaf) {
                this.setIcon(BaseXImages.text(((ResourceLeaf)val).raw));
            }
            return this;
        }
    }
}

