/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.json;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.json.JsonSerializer;
import org.basex.query.QueryError;
import org.basex.query.QueryIOException;
import org.basex.query.QueryText;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.ft.FTPos;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class JsonBasicSerializer
extends JsonSerializer {
    private boolean printKey;
    private TokenSet printedKeys = new TokenSet();

    public JsonBasicSerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts);
    }

    @Override
    protected void node(ANode node) throws IOException {
        if (this.level > 0) {
            this.indent();
        }
        BasicNodeIter iter = node.children();
        if (node.type == NodeType.DOC || node.type == NodeType.DEL) {
            ANode child;
            while ((child = iter.next()) != null) {
                this.node(child);
            }
        } else if (node.type == NodeType.ELM) {
            byte[] value;
            QNm name = node.qname();
            byte[] type = name.local();
            if (!Token.eq(name.uri(), QueryText.FN_URI)) {
                throw JsonBasicSerializer.error("Element '%' has invalid namespace: '%'.", type, name.uri());
            }
            byte[] key = null;
            boolean escaped = false;
            boolean escapedKey = false;
            for (ANode attr : node.attributes()) {
                Boolean b;
                QNm qnm = attr.qname();
                byte[] au = qnm.uri();
                byte[] an = qnm.local();
                byte[] av = attr.string();
                if (au.length != 0) {
                    if (!Token.eq(au, QueryText.FN_URI)) continue;
                    throw JsonBasicSerializer.error("Element '%' has invalid attribute: %.", type, an);
                }
                if (Token.eq(an, JsonConstants.KEY)) {
                    key = attr.string();
                    continue;
                }
                if (Token.eq(an, JsonConstants.ESCAPED_KEY) && this.printKey) {
                    b = Bln.parse(av);
                    if (b == null) {
                        throw JsonBasicSerializer.error("Value of '%' attribute is invalid: '%'.", an, av);
                    }
                    escapedKey = b;
                    continue;
                }
                if (Token.eq(an, JsonConstants.ESCAPED) && Token.eq(type, JsonConstants.STRING)) {
                    b = Bln.parse(av);
                    if (b == null) {
                        throw JsonBasicSerializer.error("Value of '%' attribute is invalid: '%'.", an, av);
                    }
                    escaped = b;
                    continue;
                }
                throw JsonBasicSerializer.error("Element '%' has invalid attribute: %.", type, an);
            }
            if (this.printKey) {
                if (key == null) {
                    throw JsonBasicSerializer.error("Element '%' has no key.", new Object[]{type});
                }
                key = this.escape(key, escapedKey, true);
                this.out.print(34);
                this.out.print(this.norm(key));
                this.out.print("\":");
            }
            if (Token.eq(type, JsonConstants.NULL)) {
                ANode n;
                this.out.print(JsonConstants.NULL);
                while ((n = iter.next()) != null) {
                    if (n.type == NodeType.COM || n.type == NodeType.PI) continue;
                    throw JsonBasicSerializer.error("Element '%' must have no children.", new Object[]{type});
                }
            } else if (Token.eq(type, JsonConstants.BOOLEAN)) {
                value = JsonBasicSerializer.value(iter, type);
                if (value == null) {
                    throw JsonBasicSerializer.error("Element '%' has no value.", new Object[]{type});
                }
                Boolean b = Bln.parse(value);
                if (b == null) {
                    throw JsonBasicSerializer.error("Element '%' has invalid value: '%'.", type, value);
                }
                this.out.print(this.norm(Token.token(b)));
            } else if (Token.eq(type, JsonConstants.STRING)) {
                value = JsonBasicSerializer.value(iter, type);
                this.out.print(34);
                if (value != null) {
                    this.out.print(this.norm(this.escape(value, escaped, false)));
                }
                this.out.print(34);
            } else if (Token.eq(type, JsonConstants.NUMBER)) {
                value = JsonBasicSerializer.value(iter, type);
                if (value == null) {
                    throw JsonBasicSerializer.error("Element '%' has no value.", new Object[]{type});
                }
                double d = Token.toDouble(value);
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    throw JsonBasicSerializer.error("Element '%' has invalid value: '%'.", type, value);
                }
                this.out.print(Token.token(d));
            } else if (Token.eq(type, JsonConstants.ARRAY)) {
                this.out.print(91);
                this.children(iter, false);
                this.out.print(93);
            } else if (Token.eq(type, JsonConstants.MAP)) {
                this.out.print(123);
                this.children(iter, true);
                this.out.print(125);
            } else {
                throw JsonBasicSerializer.error("Invalid element: '%'", name);
            }
        }
    }

    @Override
    protected void startOpen(QNm name) {
        throw Util.notExpected();
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) {
        throw Util.notExpected();
    }

    @Override
    protected void finishOpen() {
        throw Util.notExpected();
    }

    @Override
    protected void text(byte[] value, FTPos ftp) {
        throw Util.notExpected();
    }

    @Override
    protected void finishEmpty() {
        throw Util.notExpected();
    }

    @Override
    protected void finishClose() {
        throw Util.notExpected();
    }

    @Override
    protected void atomic(Item value) throws IOException {
        throw QueryError.JSON_SERIALIZE_X.getIO("Atomic values cannot be serialized");
    }

    private void children(BasicNodeIter iter, boolean pk) throws IOException {
        ANode child;
        boolean p = this.printKey;
        TokenSet keys = this.printedKeys;
        this.printKey = pk;
        this.printedKeys = new TokenSet();
        ++this.level;
        boolean comma = false;
        while ((child = iter.next()) != null) {
            if (child.type == NodeType.ELM) {
                if (comma) {
                    this.out.print(44);
                }
                this.node(child);
                comma = true;
                continue;
            }
            if (child.type != NodeType.TXT || Token.ws(child.string())) continue;
            throw JsonBasicSerializer.error("Element '%' must have no text nodes.", new Object[]{child.name()});
        }
        --this.level;
        this.indent();
        this.printKey = p;
        this.printedKeys = keys;
    }

    private static byte[] value(BasicNodeIter iter, byte[] type) throws QueryIOException {
        ANode child;
        TokenBuilder tb = null;
        while ((child = iter.next()) != null) {
            if (child.type == NodeType.TXT) {
                if (tb == null) {
                    tb = new TokenBuilder();
                }
                tb.add(child.string());
                continue;
            }
            if (child.type != NodeType.ELM) continue;
            throw JsonBasicSerializer.error("Element '%' must have no child elements.", new Object[]{type});
        }
        return tb == null ? null : tb.finish();
    }

    private byte[] escape(byte[] value, boolean escape, boolean key) throws QueryIOException {
        byte[] unescaped;
        byte[] byArray = unescaped = escape && Token.contains(value, 92) ? JsonBasicSerializer.unescape(value) : value;
        if (key && !this.printedKeys.add(unescaped)) {
            throw JsonBasicSerializer.error("Duplicate key: %.", new Object[]{value});
        }
        TokenBuilder tb = new TokenBuilder();
        boolean bs = false;
        int vl = value.length;
        for (int v = 0; v < vl; v += Token.cl(value, v)) {
            int cp = Token.cp(value, v);
            if (cp >= 0 && cp < 32 || cp >= 127 && cp < 160) {
                tb.add(92);
                switch (cp) {
                    case 8: {
                        tb.add(98);
                        break;
                    }
                    case 12: {
                        tb.add(102);
                        break;
                    }
                    case 10: {
                        tb.add(110);
                        break;
                    }
                    case 13: {
                        tb.add(114);
                        break;
                    }
                    case 9: {
                        tb.add(116);
                        break;
                    }
                    default: {
                        tb.add(117).add(48).add(48).add(Token.HEX[cp >> 4]).add(Token.HEX[cp & 0xF]);
                        break;
                    }
                }
            } else {
                if (!(cp != 92 && cp != 34 && cp != 47 || escape && (bs || cp == 92))) {
                    tb.add(92);
                }
                tb.add(cp);
            }
            bs = !bs && cp == 92;
        }
        return tb.finish();
    }

    private static byte[] unescape(byte[] value) throws QueryIOException {
        TokenBuilder raw = new TokenBuilder();
        TokenParser tp = new TokenParser(value);
        block9: while (tp.more()) {
            int cp = tp.next();
            if (cp == 92) {
                if (!tp.more()) {
                    throw QueryError.ESCAPE_JSON_X.getIO(new Object[]{value});
                }
                cp = tp.next();
                switch (cp) {
                    case 117: {
                        cp = 0;
                        for (int i = 0; i < 4; ++i) {
                            if (!tp.more()) {
                                throw QueryError.ESCAPE_JSON_X.getIO(new Object[]{value});
                            }
                            int c = tp.next();
                            if (c < 48 || c > 57 && c < 65 || c > 70 && c < 97 || c > 102) {
                                throw QueryError.ESCAPE_JSON_X.getIO(new Object[]{value});
                            }
                            cp = (cp << 4) + c - (c >= 97 ? 87 : (c >= 65 ? 55 : 48));
                        }
                        raw.add(cp);
                        continue block9;
                    }
                    case 34: 
                    case 47: 
                    case 92: {
                        raw.add(cp);
                        continue block9;
                    }
                    case 98: {
                        raw.add(8);
                        continue block9;
                    }
                    case 102: {
                        raw.add(12);
                        continue block9;
                    }
                    case 110: {
                        raw.add(10);
                        continue block9;
                    }
                    case 114: {
                        raw.add(13);
                        continue block9;
                    }
                    case 116: {
                        raw.add(9);
                        continue block9;
                    }
                }
                throw QueryError.ESCAPE_JSON_X.getIO(new Object[]{value});
            }
            raw.add(cp);
        }
        return raw.finish();
    }

    private static QueryIOException error(String msg, Object ... ext) {
        return QueryError.INVALID_JSON_X.getIO(new Object[]{Util.inf(msg, ext)});
    }
}

