/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import java.util.Objects;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.IndexType;
import org.basex.index.query.FTIndexIterator;
import org.basex.index.query.IndexIterator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTNot;
import org.basex.query.expr.ft.FTTokenizer;
import org.basex.query.expr.ft.FTTokens;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.iter.FTIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.IndexCosts;
import org.basex.query.util.IndexInfo;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.value.Value;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTBitapSearch;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTMode;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public final class FTWords
extends FTExpr {
    final FTMode mode;
    Expr query;
    Expr[] occ;
    boolean simple;
    private boolean compiled;
    private IndexDb db;
    private TokenList tokens;
    private FTOpt ftOpt;
    private final ThreadLocal<FTTokenizer> caches = new ThreadLocal();

    public FTWords(InputInfo info, Expr query, FTMode mode, Expr[] occ) {
        super(info, new FTExpr[0]);
        this.query = query;
        this.mode = mode;
        this.occ = occ;
    }

    public FTWords(InputInfo info, IndexDb db, Value query, FTMode mode) {
        super(info, new FTExpr[0]);
        this.db = db;
        this.query = query;
        this.mode = mode;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.occ);
        this.checkNoUp(this.query);
    }

    @Override
    public FTWords compile(CompileContext cc) throws QueryException {
        if (this.compiled) {
            return this;
        }
        this.compiled = true;
        if (this.occ != null) {
            int ol = this.occ.length;
            for (int o = 0; o < ol; ++o) {
                this.occ[o] = this.occ[o].compile(cc);
            }
        }
        this.query = this.query.compile(cc);
        return this.init(cc.qc, cc.qc.ftOpt());
    }

    public FTWords init(QueryContext qc, FTOpt opt) throws QueryException {
        if (this.query instanceof Value) {
            this.tokens = this.tokens(qc);
            this.simple = this.mode == FTMode.ANY && this.occ == null;
        }
        this.ftOpt = opt;
        return this;
    }

    @Override
    public FTNode item(QueryContext qc, InputInfo ii) throws QueryException {
        FTTokenizer ftt = this.get(qc);
        if (ftt.pos == 0) {
            ftt.pos = ++qc.ftPos;
        }
        ftt.matches.reset(ftt.pos);
        int count = this.contains(qc, ftt);
        if (count == 0) {
            ftt.matches.size(0);
        }
        return new FTNode(ftt.matches, count == 0 ? 0.0 : Scoring.word(count, qc.ftLexer.count()));
    }

    @Override
    public FTIter iter(final QueryContext qc) throws QueryException {
        final Data data = this.db.data(qc, IndexType.FULLTEXT);
        return new FTIter(){
            FTIndexIterator ftiter;
            int len;

            @Override
            public FTNode next() throws QueryException {
                if (this.ftiter == null) {
                    FTTokenizer ftt = FTWords.this.get(qc);
                    FTLexer lexer = new FTLexer(FTWords.this.ftOpt).lserror(qc.context.options.get(MainOptions.LSERROR));
                    int count = 0;
                    for (byte[] txt : FTWords.this.unique(FTWords.this.tokens != null ? FTWords.this.tokens : FTWords.this.tokens(qc))) {
                        lexer.init(txt);
                        if (!lexer.hasNext()) {
                            return null;
                        }
                        int d = 0;
                        IndexIterator ii = null;
                        do {
                            byte[] tok = lexer.nextToken();
                            count += tok.length;
                            if (((FTWords)FTWords.this).ftOpt.sw != null && ((FTWords)FTWords.this).ftOpt.sw.contains(tok)) {
                                ++d;
                                continue;
                            }
                            FTIndexIterator iter = lexer.get().length > data.meta.maxlen ? FTWords.this.scan(lexer, ftt, data) : (FTIndexIterator)data.iter(lexer);
                            iter.pos(++qc.ftPos);
                            if (ii == null) {
                                ii = iter;
                                continue;
                            }
                            ii = FTIndexIterator.intersect((FTIndexIterator)ii, iter, ++d);
                            d = 0;
                        } while (lexer.hasNext());
                        if (ii == null) continue;
                        if (this.ftiter == null) {
                            this.len = count;
                            this.ftiter = ii;
                            continue;
                        }
                        if (FTWords.this.mode == FTMode.ALL || FTWords.this.mode == FTMode.ALL_WORDS) {
                            if (ii.size() == 0) {
                                return null;
                            }
                            this.len += count;
                            this.ftiter = FTIndexIterator.intersect(this.ftiter, (FTIndexIterator)ii, 0);
                            continue;
                        }
                        if (ii.size() == 0) continue;
                        this.len = Math.max(count, this.len);
                        this.ftiter = FTIndexIterator.union(this.ftiter, (FTIndexIterator)ii);
                    }
                }
                return this.ftiter == null || !this.ftiter.more() ? null : new FTNode(this.ftiter.matches(), data, this.ftiter.pre(), this.len, this.ftiter.size(), -1.0);
            }
        };
    }

    private FTIndexIterator scan(FTLexer lexer, final FTTokenizer ftt, final Data data) throws QueryException {
        final FTLexer input = new FTLexer(this.ftOpt);
        final FTTokens fttokens = ftt.cache(lexer.get());
        return new FTIndexIterator(){
            final int sz;
            int pre;
            int ps;
            {
                this.sz = data.meta.size;
                this.pre = -1;
            }

            @Override
            public int pre() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < this.sz) {
                    if (data.kind(this.pre) != 2) continue;
                    input.init(data.text(this.pre, true));
                    ftt.matches.reset(this.ps);
                    try {
                        if (FTWords.this.contains(fttokens, input, ftt) == 0) continue;
                        return true;
                    }
                    catch (QueryException queryException) {
                    }
                }
                return false;
            }

            @Override
            public FTMatches matches() {
                return ftt.matches;
            }

            @Override
            public void pos(int p) {
                this.ps = p;
            }

            @Override
            public int size() {
                return Math.max(1, this.sz >>> 1);
            }
        };
    }

    private TokenList tokens(QueryContext qc) throws QueryException {
        Item item;
        TokenList tl = new TokenList();
        Iter iter = this.query.iter(qc);
        while ((item = qc.next(iter)) != null) {
            byte[] qu = this.toToken(item);
            if (qu.length == 0 && this.mode != FTMode.ALL && this.mode != FTMode.ALL_WORDS) continue;
            tl.add(qu);
        }
        return tl;
    }

    private int contains(QueryContext qc, FTTokenizer ftt) throws QueryException {
        long mx;
        ftt.first = true;
        FTLexer lexer = qc.ftLexer.copy(this.ftOpt);
        int num = 0;
        if (this.simple) {
            for (byte[] token : this.tokens) {
                FTTokens qtok = ftt.cache(token);
                num = Math.max(num, this.contains(qtok, lexer, ftt) * qtok.firstSize());
            }
            return num;
        }
        boolean all = this.mode == FTMode.ALL || this.mode == FTMode.ALL_WORDS;
        int oc = 0;
        for (byte[] w : this.unique(this.tokens(qc))) {
            FTTokens qtok = ftt.cache(w);
            int o = this.contains(qtok, lexer, ftt);
            if (all && o == 0) {
                return 0;
            }
            num = Math.max(num, o * qtok.firstSize());
            oc += o;
        }
        long mn = this.occ != null ? this.toLong(this.occ[0], qc) : 1L;
        long l = mx = this.occ != null ? this.toLong(this.occ[1], qc) : Long.MAX_VALUE;
        if (mn == 0L && oc == 0) {
            ftt.matches = FTNot.not(ftt.matches);
        }
        return (long)oc >= mn && (long)oc <= mx ? Math.max(1, num) : 0;
    }

    private int contains(FTTokens tok, FTLexer input, FTTokenizer ftt) throws QueryException {
        int count = 0;
        FTMatches matches = ftt.matches;
        boolean and = !ftt.first && (this.mode == FTMode.ALL || this.mode == FTMode.ALL_WORDS);
        FTBitapSearch bs = new FTBitapSearch(input.init(), tok, ftt.cmp);
        while (bs.hasNext()) {
            int s = bs.next();
            int e = s + tok.firstSize() - 1;
            if (and) {
                matches.and(s, e);
            } else {
                matches.or(s, e);
            }
            ++count;
        }
        ++matches.pos;
        ftt.first = false;
        return count;
    }

    private TokenSet unique(TokenList tl) {
        TokenSet ts = new TokenSet();
        switch (this.mode) {
            case ALL: 
            case ANY: {
                for (byte[] token : tl) {
                    ts.add(token);
                }
                break;
            }
            case ALL_WORDS: 
            case ANY_WORD: {
                FTLexer lexer = new FTLexer(this.ftOpt);
                for (byte[] token : tl) {
                    lexer.init(token);
                    while (lexer.hasNext()) {
                        ts.add(lexer.nextToken());
                    }
                }
                break;
            }
            case PHRASE: {
                TokenBuilder tb = new TokenBuilder();
                for (byte[] token : tl) {
                    tb.add(token).add(32);
                }
                ts.add(tb.trim().finish());
            }
        }
        return ts;
    }

    private FTTokenizer get(QueryContext qc) {
        FTTokenizer ftt = this.caches.get();
        if (ftt == null) {
            ftt = new FTTokenizer(this.ftOpt, qc, this.info);
            this.caches.set(ftt);
        }
        return ftt;
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) {
        Data data = ii.db.data();
        if (data == null && !ii.enforce() || this.occ != null) {
            return false;
        }
        if (data != null) {
            MetaData md = data.meta;
            if (this.ftOpt.cs != null && md.casesens == (this.ftOpt.cs == FTCase.INSENSITIVE) || this.ftOpt.isSet(FTFlag.DC) && md.diacritics != this.ftOpt.is(FTFlag.DC) || this.ftOpt.isSet(FTFlag.ST) && md.stemming != this.ftOpt.is(FTFlag.ST) || this.ftOpt.ln != null && !this.ftOpt.ln.equals(md.language)) {
                return false;
            }
            this.ftOpt.assign(md);
        }
        if (this.tokens == null) {
            ii.costs = data == null ? null : IndexCosts.get(Math.max(2, data.meta.size / 30));
        } else {
            FTLexer lexer = new FTLexer(this.ftOpt);
            ii.costs = IndexCosts.ZERO;
            for (byte[] token : this.tokens) {
                lexer.init(token);
                while (lexer.hasNext()) {
                    IndexCosts c;
                    byte[] tok = lexer.nextToken();
                    if (this.ftOpt.sw != null && this.ftOpt.sw.contains(tok)) continue;
                    if (this.ftOpt.is(FTFlag.WC)) {
                        token = lexer.get();
                        if (token[0] == 46) {
                            return false;
                        }
                        int d = 0;
                        for (byte w : token) {
                            if (w != 123 && w != 92 && (w != 46 || ++d <= 1)) continue;
                            return false;
                        }
                    }
                    if ((c = ii.costs(data, lexer)) == null) {
                        return false;
                    }
                    int r = c.results();
                    if (r == 0) continue;
                    ii.costs = IndexCosts.add(ii.costs, IndexCosts.get(Math.max(2, r / 100)));
                }
            }
        }
        this.db = ii.db;
        return true;
    }

    @Override
    public boolean usesExclude() {
        return this.occ != null;
    }

    @Override
    public boolean has(Flag ... flags) {
        if (this.occ != null) {
            for (Expr o : this.occ) {
                if (!o.has(flags)) continue;
                return true;
            }
        }
        return this.query.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        if (this.occ != null) {
            for (Expr o : this.occ) {
                if (o.removable(var)) continue;
                return false;
            }
        }
        return this.query.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return this.occ != null ? VarUsage.sum(var, this.occ).plus(this.query.count(var)) : this.query.count(var);
    }

    @Override
    public FTExpr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = this.occ != null && FTWords.inlineAll(this.occ, var, ex, cc);
        Expr q = this.query.inline(var, ex, cc);
        if (q != null) {
            this.query = q;
            changed = true;
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        FTWords ftw = new FTWords(this.info, this.query.copy(cc, vm), this.mode, this.occ == null ? null : Arr.copyAll((CompileContext)cc, vm, (Expr[])this.occ));
        ftw.simple = this.simple;
        ftw.compiled = this.compiled;
        ftw.tokens = this.tokens;
        ftw.ftOpt = this.ftOpt;
        if (this.db != null) {
            ftw.db = this.db.copy(cc, (IntObjMap)vm);
        }
        return ftw;
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && this.query.accept(visitor) && (this.occ == null || FTWords.visitAll(visitor, this.occ));
    }

    @Override
    public int exprSize() {
        int size = 1;
        if (this.occ != null) {
            for (Expr expr : this.occ) {
                size += expr.exprSize();
            }
        }
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size + this.query.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FTWords)) {
            return false;
        }
        FTWords f = (FTWords)obj;
        return this.query.equals(f.query) && this.mode == f.mode && Objects.equals(this.db, f.db) && Array.equals(this.occ, f.occ) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        FTWords.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.occ, this.query});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean str = this.query instanceof AStr;
        if (!str) {
            sb.append("{ ");
        }
        sb.append(this.query);
        if (!str) {
            sb.append(" }");
        }
        switch (this.mode) {
            case ALL: {
                sb.append(" all");
                break;
            }
            case ALL_WORDS: {
                sb.append(" all words");
                break;
            }
            case ANY_WORD: {
                sb.append(" any word");
                break;
            }
            case PHRASE: {
                sb.append(" phrase");
                break;
            }
        }
        if (this.occ != null) {
            sb.append("occurs ").append(this.occ[0]).append(' ').append("to").append(' ').append(this.occ[1]).append(' ').append("times");
        }
        if (this.ftOpt != null) {
            sb.append(this.ftOpt);
        }
        return sb.toString();
    }
}

