/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileRead;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class FileList
extends FileRead {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        this.checkCreate(qc);
        try {
            Path dir = this.toPath(0, qc).toRealPath(new LinkOption[0]);
            boolean recursive = this.optionalBool(1, qc);
            Pattern pattern = this.exprs.length == 3 ? Pattern.compile(IOFile.regex(Token.string(this.toToken(this.exprs[2], qc))), Prop.CASE ? 0 : 2) : null;
            TokenList tl = new TokenList();
            FileList.list(dir.getNameCount(), dir, tl, recursive, pattern);
            return StrSeq.get(tl);
        }
        catch (NoSuchFileException | NotDirectoryException ex) {
            throw QueryError.FILE_NO_DIR_X.get(this.info, ex);
        }
        catch (AccessDeniedException ex) {
            throw QueryError.FILE_IE_ERROR_ACCESS_X.get(this.info, ex);
        }
        catch (IOException ex) {
            throw QueryError.FILE_IO_ERROR_X.get(this.info, ex);
        }
    }

    private static void list(int index, Path dir, TokenList list, boolean rec, Pattern pat) throws IOException {
        ArrayList<Path> children;
        block18: {
            children = new ArrayList<Path>();
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(dir);){
                for (Path child : paths) {
                    children.add(child);
                }
            }
            catch (IOException ex) {
                if (index != dir.getNameCount()) break block18;
                throw ex;
            }
        }
        if (rec) {
            for (Path child : children) {
                if (!Files.isDirectory(child, new LinkOption[0])) continue;
                FileList.list(index, child, list, true, pat);
            }
        }
        for (Path child : children) {
            if (pat != null && !pat.matcher(child.getFileName().toString()).matches()) continue;
            Path path = child.subpath(index, child.getNameCount());
            list.add(FileList.get(path, Files.isDirectory(child, new LinkOption[0])).string());
        }
    }
}

