/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.zip;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.io.in.NewlineInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.zip.ZipBinaryEntry;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class ZipTextEntry
extends ZipBinaryEntry {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        String encoding = this.exprs.length < 3 ? null : Token.string(this.toToken(this.exprs[2], qc));
        byte[] entry = this.entry(qc);
        boolean validate = qc.context.options.get(MainOptions.CHECKSTRINGS);
        try (NewlineInput ni = new NewlineInput(entry);){
            Str str = Str.get(ni.encoding(encoding).validate(validate).content());
            return str;
        }
        catch (IOException ex) {
            throw QueryError.ZIP_FAIL_X.get(this.info, ex);
        }
    }
}

