/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.query.expr.Expr;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Util;

public final class ExprType {
    private SeqType seqType;
    private long size = -1L;

    public ExprType(SeqType seqType) {
        this.assign(seqType);
    }

    public SeqType seqType() {
        return this.seqType;
    }

    public long size() {
        return this.size;
    }

    public void assign(SeqType st, long sz) {
        this.seqType = st;
        this.size = sz;
    }

    public void assign(SeqType st) {
        this.assign(st, st.zero() ? 0L : (st.one() ? 1L : -1L));
    }

    public void assign(Expr expr) {
        this.assign(expr.seqType(), expr.size());
    }

    public void assign(ExprType et) {
        this.assign(et.seqType, et.size);
    }

    public void assign(Type type) {
        this.seqType = this.seqType.with(type);
    }

    public void assign(Type type, Occ occ) {
        this.assign(this.seqType.with(type, occ));
    }

    public void assign(Occ occ) {
        this.assign(this.seqType.with(occ));
    }

    public void assign(Type type, Occ occ, long sz) {
        if (sz >= 0L) {
            Occ oc = sz == 0L ? Occ.ZERO : (sz == 1L ? Occ.ONE : (sz > 1L ? Occ.ONE_MORE : Occ.ZERO_MORE));
            this.assign(this.seqType.with(type, oc), sz);
        } else {
            this.assign(type, occ);
        }
    }

    public void assign(Type type, long[] minMax) {
        long sz;
        long min = minMax[0];
        long max = minMax[1];
        long l = sz = min == max ? min : -1L;
        Occ occ = min == 0L ? (max == 1L ? Occ.ZERO_ONE : Occ.ZERO_MORE) : Occ.ONE_MORE;
        this.assign(type, occ, sz);
    }

    public String toString() {
        return Util.className(this) + '[' + this.seqType + ", " + this.size + ']';
    }
}

