/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.options;

import org.basex.util.list.StringList;
import org.basex.util.options.Option;

public final class EnumOption<V extends Enum<V>>
extends Option<V> {
    private final Class<V> clazz;
    private final V value;

    public EnumOption(String name, V value) {
        super(name);
        this.value = value;
        this.clazz = value.getClass();
    }

    public EnumOption(String name, Class<V> clazz) {
        super(name);
        this.clazz = clazz;
        this.value = null;
    }

    @Override
    public V value() {
        return this.value;
    }

    public V get(String string) {
        for (Enum v : this.values()) {
            if (!v.toString().equals(string)) continue;
            return (V)v;
        }
        return null;
    }

    public V[] values() {
        return (Enum[])this.clazz.getEnumConstants();
    }

    public String[] strings() {
        Enum[] values = this.values();
        StringList sl = new StringList(values.length);
        for (Enum v : values) {
            sl.add(v.toString());
        }
        return (String[])sl.finish();
    }
}

