/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.common.StringSplitUtils;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Auth {
    private static final Logger log = LoggerFactory.getLogger(Auth.class);
    private Object tag;
    private Scheme scheme;
    private String user;
    private String password;
    private String realm;
    private String nonce;
    private String uri;
    private String responseDigest;
    private String qop;
    private String nc;
    private String cnonce;
    private boolean nonceStale;

    public Auth(String sAuth) {
        String enc;
        int pos = sAuth.indexOf(" ");
        if (pos >= 0) {
            String schemeCode = sAuth.substring(0, pos);
            this.scheme = Scheme.valueOf(schemeCode.toUpperCase());
            enc = sAuth.substring(pos + 1);
        } else {
            this.scheme = Scheme.BASIC;
            enc = sAuth;
        }
        if (this.scheme.equals((Object)Scheme.BASIC)) {
            this.parseBasic(enc);
        } else if (this.scheme.equals((Object)Scheme.DIGEST)) {
            this.parseDigest(enc);
        }
    }

    public Auth(String user, Object userTag) {
        this.scheme = Scheme.BASIC;
        this.user = user;
        this.password = null;
        this.tag = userTag;
    }

    public Auth(Scheme scheme, String user, Object userTag) {
        this.scheme = scheme;
        this.user = user;
        this.password = null;
        this.tag = userTag;
    }

    public String getUser() {
        return this.user;
    }

    public void setTag(Object authTag) {
        this.tag = authTag;
    }

    public Object getTag() {
        return this.tag;
    }

    public String getPassword() {
        return this.password;
    }

    public Scheme getScheme() {
        return this.scheme;
    }

    public String getCnonce() {
        return this.cnonce;
    }

    public String getNc() {
        return this.nc;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getQop() {
        return this.qop;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getResponseDigest() {
        return this.responseDigest;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isNonceStale() {
        return this.nonceStale;
    }

    public void setNonceStale(boolean nonceStale) {
        this.nonceStale = nonceStale;
    }

    private void parseBasic(String enc) {
        byte[] bytes;
        try {
            bytes = Base64.decodeBase64((byte[])enc.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        String s = new String(bytes);
        int pos = s.indexOf(":");
        if (pos >= 0) {
            this.user = s.substring(0, pos);
            this.password = s.substring(pos + 1);
        } else {
            this.user = s;
            this.password = null;
        }
    }

    private void parseDigest(String s) {
        String[] headerEntries = StringSplitUtils.splitIgnoringQuotes(s, ',');
        Map headerMap = StringSplitUtils.splitEachArrayElementAndCreateMap(headerEntries, "=", "\"");
        this.user = (String)headerMap.get("username");
        this.realm = (String)headerMap.get("realm");
        this.nonce = (String)headerMap.get("nonce");
        this.uri = (String)headerMap.get("uri");
        this.responseDigest = (String)headerMap.get("response");
        this.qop = (String)headerMap.get("qop");
        this.nc = (String)headerMap.get("nc");
        this.cnonce = (String)headerMap.get("cnonce");
    }

    public String toString() {
        return "scheme: " + (Object)((Object)this.scheme) + " user:" + this.user + " tag:" + this.tag;
    }

    public static enum Scheme {
        BASIC,
        DIGEST,
        NEGOTIATE,
        FORM,
        SESSION,
        NTLM,
        OAUTH;

    }
}

