/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.AuthenticationService;
import com.bradmcevoy.http.EventListener;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.Filter;
import com.bradmcevoy.http.FilterChain;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HttpExtension;
import com.bradmcevoy.http.ProtocolHandlers;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.SessionAuthenticationHandler;
import com.bradmcevoy.http.StandardFilter;
import com.bradmcevoy.http.Utils;
import com.bradmcevoy.http.entity.DefaultEntityTransport;
import com.bradmcevoy.http.entity.EntityTransport;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.http11.Bufferable;
import com.bradmcevoy.http.http11.CustomPostHandler;
import com.bradmcevoy.http.http11.DefaultHttp11ResponseHandler;
import com.bradmcevoy.http.http11.Http11ResponseHandler;
import com.bradmcevoy.http.http11.auth.ExpiredNonceRemover;
import com.bradmcevoy.http.http11.auth.Nonce;
import com.bradmcevoy.http.http11.auth.SimpleMemoryNonceProvider;
import com.bradmcevoy.http.webdav.DefaultWebDavResponseHandler;
import com.bradmcevoy.http.webdav.WebDavResponseHandler;
import com.bradmcevoy.property.PropertyAuthoriser;
import com.bradmcevoy.property.PropertyHandler;
import com.ettrema.common.Stoppable;
import com.ettrema.event.EventManager;
import com.ettrema.event.EventManagerImpl;
import com.ettrema.event.RequestEvent;
import com.ettrema.event.ResponseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpManager {
    private static final Logger log = LoggerFactory.getLogger(HttpManager.class);
    private static final ThreadLocal<Request> tlRequest = new ThreadLocal();
    private static final ThreadLocal<Response> tlResponse = new ThreadLocal();
    private final ProtocolHandlers handlers;
    private Map<String, Handler> methodHandlers = new ConcurrentHashMap<String, Handler>();
    List<Filter> filters = new ArrayList<Filter>();
    List<EventListener> eventListeners = new ArrayList<EventListener>();
    protected final ResourceFactory resourceFactory;
    protected final Http11ResponseHandler responseHandler;
    private SessionAuthenticationHandler sessionAuthenticationHandler;
    private PropertyAuthoriser propertyPermissionService;
    private EventManager eventManager = new EventManagerImpl();
    private final List<Stoppable> shutdownHandlers = new CopyOnWriteArrayList<Stoppable>();
    private EntityTransport entityTransport;

    public static String decodeUrl(String s) {
        return Utils.decodePath(s);
    }

    public static Request request() {
        return tlRequest.get();
    }

    public static Response response() {
        return tlResponse.get();
    }

    public HttpManager(ResourceFactory resourceFactory) {
        if (resourceFactory == null) {
            throw new NullPointerException("resourceFactory cannot be null");
        }
        this.resourceFactory = resourceFactory;
        ConcurrentHashMap<UUID, Nonce> nonces = new ConcurrentHashMap<UUID, Nonce>();
        int nonceValiditySeconds = 86400;
        ExpiredNonceRemover expiredNonceRemover = new ExpiredNonceRemover(nonces, nonceValiditySeconds);
        SimpleMemoryNonceProvider nonceProvider = new SimpleMemoryNonceProvider(nonceValiditySeconds, expiredNonceRemover, nonces);
        AuthenticationService authenticationService = new AuthenticationService(nonceProvider);
        DefaultWebDavResponseHandler webdavResponseHandler = new DefaultWebDavResponseHandler(authenticationService);
        this.responseHandler = webdavResponseHandler;
        this.handlers = new ProtocolHandlers((WebDavResponseHandler)webdavResponseHandler, authenticationService);
        this.entityTransport = new DefaultEntityTransport();
        this.initHandlers();
        this.shutdownHandlers.add(expiredNonceRemover);
        expiredNonceRemover.start();
    }

    public HttpManager(ResourceFactory resourceFactory, AuthenticationService authenticationService) {
        if (resourceFactory == null) {
            throw new NullPointerException("resourceFactory cannot be null");
        }
        this.resourceFactory = resourceFactory;
        DefaultWebDavResponseHandler webdavResponseHandler = new DefaultWebDavResponseHandler(authenticationService);
        this.responseHandler = webdavResponseHandler;
        this.handlers = new ProtocolHandlers((WebDavResponseHandler)webdavResponseHandler, authenticationService);
        this.entityTransport = new DefaultEntityTransport();
        this.initHandlers();
    }

    public HttpManager(ResourceFactory resourceFactory, WebDavResponseHandler responseHandler, AuthenticationService authenticationService) {
        if (resourceFactory == null) {
            throw new NullPointerException("resourceFactory cannot be null");
        }
        this.resourceFactory = resourceFactory;
        this.responseHandler = responseHandler;
        this.handlers = new ProtocolHandlers(responseHandler, authenticationService);
        this.entityTransport = new DefaultEntityTransport();
        this.initHandlers();
    }

    public HttpManager(ResourceFactory resourceFactory, WebDavResponseHandler responseHandler, ProtocolHandlers handlers) {
        if (resourceFactory == null) {
            throw new NullPointerException("resourceFactory cannot be null");
        }
        this.resourceFactory = resourceFactory;
        this.responseHandler = responseHandler;
        this.handlers = handlers;
        this.entityTransport = new DefaultEntityTransport();
        this.initHandlers();
    }

    public void sendResponseEntity(Response response) throws Exception {
        this.entityTransport.sendResponseEntity(response);
    }

    public void closeResponse(Response response) {
        this.entityTransport.closeResponse(response);
    }

    private void initHandlers() {
        for (HttpExtension ext : this.handlers) {
            for (Handler h : ext.getHandlers()) {
                for (String m : h.getMethods()) {
                    this.methodHandlers.put(m, h);
                }
            }
        }
        this.filters.add(this.createStandardFilter());
    }

    public Handler getMethodHandler(Request.Method m) {
        return this.methodHandlers.get(m.code);
    }

    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    public SessionAuthenticationHandler getSessionAuthenticationHandler() {
        return this.sessionAuthenticationHandler;
    }

    public void setSessionAuthenticationHandler(SessionAuthenticationHandler sessionAuthenticationHandler) {
        this.sessionAuthenticationHandler = sessionAuthenticationHandler;
    }

    @Deprecated
    public Auth getSessionAuthentication(Request request) {
        if (this.sessionAuthenticationHandler == null) {
            return null;
        }
        return this.sessionAuthenticationHandler.getSessionAuthentication(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Request request, Response response) {
        if (log.isInfoEnabled()) {
            log.info((Object)((Object)request.getMethod()) + " :: " + request.getAbsoluteUrl() + " - " + request.getAbsoluteUrl());
        }
        tlRequest.set(request);
        tlResponse.set(response);
        try {
            this.fireRequestEvent(request);
        }
        catch (ConflictException ex) {
            this.responseHandler.respondConflict(null, response, request, null);
        }
        catch (BadRequestException ex) {
            this.responseHandler.respondBadRequest(null, response, request);
        }
        catch (NotAuthorizedException ex) {
            this.responseHandler.respondUnauthorised(null, response, request);
        }
        try {
            FilterChain chain = new FilterChain(this);
            chain.process(request, response);
            try {
                this.fireResponseEvent(request, response);
            }
            catch (ConflictException ex) {
                log.warn("exception thrown from event handler after response is complete", (Throwable)ex);
            }
            catch (BadRequestException ex) {
                log.warn("exception thrown from event handler after response is complete", (Throwable)ex);
            }
            catch (NotAuthorizedException ex) {
                log.warn("exception thrown from event handler after response is complete", (Throwable)ex);
            }
        }
        finally {
            tlRequest.remove();
            tlResponse.remove();
        }
    }

    protected Filter createStandardFilter() {
        return new StandardFilter();
    }

    public void addFilter(int pos, Filter filter) {
        this.filters.add(pos, filter);
    }

    public void addEventListener(EventListener l) {
        this.eventListeners.add(l);
    }

    public void removeEventListener(EventListener l) {
        this.eventListeners.remove(l);
    }

    public void onProcessResourceFinish(Request request, Response response, Resource resource, long duration) {
        for (EventListener l : this.eventListeners) {
            l.onProcessResourceFinish(request, response, resource, duration);
        }
    }

    public void onProcessResourceStart(Request request, Response response, Resource resource) {
        for (EventListener l : this.eventListeners) {
            l.onProcessResourceStart(request, response, resource);
        }
    }

    public void onPost(Request request, Response response, Resource resource, Map<String, String> params, Map<String, FileItem> files) {
        for (EventListener l : this.eventListeners) {
            l.onPost(request, response, resource, params, files);
        }
    }

    public void onGet(Request request, Response response, Resource resource, Map<String, String> params) {
        for (EventListener l : this.eventListeners) {
            l.onGet(request, response, resource, params);
        }
    }

    public List<Filter> getFilters() {
        ArrayList<Filter> col = new ArrayList<Filter>(this.filters);
        return col;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
        filters.add(this.createStandardFilter());
    }

    public void setEventListeners(List<EventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public Collection<Handler> getAllHandlers() {
        return this.methodHandlers.values();
    }

    public Http11ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public ProtocolHandlers getHandlers() {
        return this.handlers;
    }

    public PropertyAuthoriser getPropertyPermissionService() {
        return this.propertyPermissionService;
    }

    public void setPropertyPermissionService(PropertyAuthoriser propertyPermissionService) {
        log.trace("setPropertyPermissionService: " + propertyPermissionService.getClass().getCanonicalName());
        this.propertyPermissionService = propertyPermissionService;
        for (Handler h : this.methodHandlers.values()) {
            if (!(h instanceof PropertyHandler)) continue;
            PropertyHandler ph = (PropertyHandler)h;
            log.trace("set propertyPermissionService on: " + ph.getClass().getCanonicalName());
            ph.setPermissionService(propertyPermissionService);
        }
    }

    public boolean isEnableExpectContinue() {
        return this.handlers.isEnableExpectContinue();
    }

    public void setEnableExpectContinue(boolean enableExpectContinue) {
        this.handlers.setEnableExpectContinue(enableExpectContinue);
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    private void fireRequestEvent(Request request) throws ConflictException, BadRequestException, NotAuthorizedException {
        if (this.eventManager == null) {
            return;
        }
        this.eventManager.fireEvent(new RequestEvent(request));
    }

    private void fireResponseEvent(Request request, Response response) throws ConflictException, BadRequestException, NotAuthorizedException {
        if (this.eventManager == null) {
            return;
        }
        this.eventManager.fireEvent(new ResponseEvent(request, response));
    }

    public List<CustomPostHandler> getCustomPostHandlers() {
        ArrayList<CustomPostHandler> list = new ArrayList<CustomPostHandler>();
        for (HttpExtension p : this.handlers) {
            if (p.getCustomPostHandlers() == null) continue;
            for (CustomPostHandler h : p.getCustomPostHandlers()) {
                list.add(h);
            }
        }
        return list;
    }

    public final void shutdown() {
        for (Stoppable stoppable : this.shutdownHandlers) {
            try {
                stoppable.stop();
            }
            catch (Throwable e) {
                log.warn("Exception stopping: " + stoppable.getClass(), e);
            }
        }
    }

    public DefaultHttp11ResponseHandler.BUFFERING getBuffering() {
        if (this.responseHandler instanceof Bufferable) {
            Bufferable hrh = (Bufferable)((Object)this.responseHandler);
            return hrh.getBuffering();
        }
        return null;
    }

    public void setBuffering(DefaultHttp11ResponseHandler.BUFFERING buffering) {
        if (!(this.responseHandler instanceof Bufferable)) {
            throw new RuntimeException("Can't set buffering on unsupported Http11ResponseHandler: " + this.responseHandler.getClass());
        }
        Bufferable hrh = (Bufferable)((Object)this.responseHandler);
        hrh.setBuffering(buffering);
    }

    public EntityTransport getEntityTransport() {
        return this.entityTransport;
    }

    public void setEntityTransport(EntityTransport entityTransport) {
        this.entityTransport = entityTransport;
    }
}

