/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.webdav.PropFindRequestFieldParser;
import com.bradmcevoy.http.webdav.PropFindSaxHandler;
import com.bradmcevoy.http.webdav.PropertiesRequest;
import com.bradmcevoy.io.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import javax.xml.namespace.QName;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DefaultPropFindRequestFieldParser
implements PropFindRequestFieldParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultPropFindRequestFieldParser.class);

    @Override
    public PropertiesRequest getRequestedFields(InputStream in) {
        try {
            LinkedHashSet<QName> set = new LinkedHashSet<QName>();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            StreamUtils.readTo(in, (OutputStream)bout, false, true);
            byte[] arr = bout.toByteArray();
            if (arr.length > 1) {
                ByteArrayInputStream bin = new ByteArrayInputStream(arr);
                XMLReader reader = XMLReaderFactory.createXMLReader();
                PropFindSaxHandler handler = new PropFindSaxHandler();
                reader.setContentHandler(handler);
                try {
                    reader.parse(new InputSource(bin));
                    if (handler.isAllProp()) {
                        return new PropertiesRequest();
                    }
                    set.addAll(handler.getAttributes().keySet());
                }
                catch (IOException e) {
                    log.warn("exception parsing request body", (Throwable)e);
                }
                catch (SAXException e) {
                    log.warn("exception parsing request body", (Throwable)e);
                }
            }
            return PropertiesRequest.toProperties(set);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

