/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.io;

import com.bradmcevoy.io.FileDeletingInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferingOutputStream
extends OutputStream {
    private static Logger log = LoggerFactory.getLogger(BufferingOutputStream.class);
    private ByteArrayOutputStream tempMemoryBuffer = new ByteArrayOutputStream();
    private int maxMemorySize;
    private File tempFile;
    private FileOutputStream fout;
    private BufferedOutputStream bufOut;
    private Runnable runnable;
    private long size;
    private boolean closed;

    public BufferingOutputStream(int maxMemorySize) {
        this.maxMemorySize = maxMemorySize;
    }

    public InputStream getInputStream() {
        if (!this.closed) {
            throw new IllegalStateException("this output stream is not yet closed");
        }
        if (this.tempMemoryBuffer == null) {
            FileDeletingInputStream fin;
            try {
                fin = new FileDeletingInputStream(this.tempFile);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(this.tempFile.getAbsolutePath(), ex);
            }
            BufferedInputStream bufIn = new BufferedInputStream(fin);
            return bufIn;
        }
        return new ByteArrayInputStream(this.tempMemoryBuffer.toByteArray());
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.size += (long)b.length;
        if (this.tempMemoryBuffer != null) {
            this.tempMemoryBuffer.write(b);
        } else {
            this.bufOut.write(b);
        }
        this.checkSize();
    }

    @Override
    public void write(int b) throws IOException {
        ++this.size;
        if (this.tempMemoryBuffer != null) {
            this.tempMemoryBuffer.write(b);
        } else {
            this.bufOut.write(b);
        }
        this.checkSize();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.size += (long)len;
        if (this.tempMemoryBuffer != null) {
            this.tempMemoryBuffer.write(b, off, len);
        } else {
            this.bufOut.write(b, off, len);
        }
        this.checkSize();
    }

    private void checkSize() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("checkSize: " + this.size);
        }
        if (this.tempMemoryBuffer == null) {
            return;
        }
        if (this.tempMemoryBuffer.size() < this.maxMemorySize) {
            return;
        }
        this.tempFile = File.createTempFile("" + System.currentTimeMillis(), ".buffer");
        this.fout = new FileOutputStream(this.tempFile);
        this.bufOut = new BufferedOutputStream(this.fout);
        this.bufOut.write(this.tempMemoryBuffer.toByteArray());
        this.tempMemoryBuffer = null;
    }

    @Override
    public void flush() throws IOException {
        if (this.tempMemoryBuffer != null) {
            this.tempMemoryBuffer.flush();
        } else {
            this.bufOut.flush();
            this.fout.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.tempMemoryBuffer != null) {
            this.tempMemoryBuffer.close();
        } else {
            this.bufOut.close();
            this.fout.close();
        }
        this.closed = true;
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public long getSize() {
        return this.size;
    }

    File getTempFile() {
        return this.tempFile;
    }

    ByteArrayOutputStream getTempMemoryBuffer() {
        return this.tempMemoryBuffer;
    }

    public void setOnClose(Runnable r) {
        this.runnable = r;
    }

    public boolean isCompleteInMemory() {
        return this.tempFile == null;
    }

    public byte[] getInMemoryData() {
        return this.tempMemoryBuffer.toByteArray();
    }

    protected void finalize() throws Throwable {
        this.deleteTempFileIfExists();
        super.finalize();
    }

    public void deleteTempFileIfExists() {
        if (this.bufOut != null) {
            IOUtils.closeQuietly((OutputStream)this.bufOut);
        }
        if (this.fout != null) {
            IOUtils.closeQuietly((OutputStream)this.fout);
        }
        if (this.tempFile != null && this.tempFile.exists()) {
            log.error("temporary file was not deleted. Was close called on the inputstream? Will attempt to delete");
            if (!this.tempFile.delete()) {
                log.error("Still couldnt delete temporary file: " + this.tempFile.getAbsolutePath());
            }
        }
    }
}

