/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.Locale;
import java.util.Random;
import org.basex.io.IOFile;
import org.basex.io.IOUrl;
import org.basex.util.Prop;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Comment;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public final class StaticOptions
extends Options {
    public static final Comment C_GENERAL = new Comment("General Options");
    public static final BooleanOption DEBUG = new BooleanOption("DEBUG", false);
    public static final StringOption DBPATH = new StringOption("DBPATH", Prop.HOMEDIR + "data");
    public static final StringOption LOGPATH = new StringOption("LOGPATH", ".logs");
    public static final StringOption REPOPATH = new StringOption("REPOPATH", Prop.HOMEDIR + "repo");
    public static final StringOption LANG = new StringOption("LANG", Prop.language);
    public static final BooleanOption LANGKEYS = new BooleanOption("LANGKEYS", false);
    public static final BooleanOption FAIRLOCK = new BooleanOption("FAIRLOCK", false);
    public static final NumberOption CACHETIMEOUT = new NumberOption("CACHETIMEOUT", 3600);
    public static final Comment C_CLIENT = new Comment("Client/Server Architecture");
    public static final StringOption HOST = new StringOption("HOST", "localhost");
    public static final NumberOption PORT = new NumberOption("PORT", 1984);
    public static final NumberOption SERVERPORT = new NumberOption("SERVERPORT", 1984);
    public static final StringOption USER = new StringOption("USER", "");
    public static final StringOption PASSWORD = new StringOption("PASSWORD", "");
    public static final StringOption SERVERHOST = new StringOption("SERVERHOST", "");
    public static final StringOption PROXYHOST = new StringOption("PROXYHOST", "");
    public static final NumberOption PROXYPORT = new NumberOption("PROXYPORT", 0);
    public static final StringOption NONPROXYHOSTS = new StringOption("NONPROXYHOSTS", "");
    public static final BooleanOption IGNORECERT = new BooleanOption("IGNORECERT", false);
    public static final BooleanOption IGNOREHOSTNAME = new BooleanOption("IGNOREHOSTNAME", false);
    public static final NumberOption TIMEOUT = new NumberOption("TIMEOUT", 30);
    public static final NumberOption KEEPALIVE = new NumberOption("KEEPALIVE", 600);
    public static final NumberOption PARALLEL = new NumberOption("PARALLEL", 8);
    public static final BooleanOption LOG = new BooleanOption("LOG", true);
    public static final NumberOption LOGMSGMAXLEN = new NumberOption("LOGMSGMAXLEN", 1000);
    public static final Comment C_HTTP = new Comment("HTTP Services");
    public static final StringOption WEBPATH = new StringOption("WEBPATH", Prop.HOMEDIR + "webapp");
    public static final StringOption RESTPATH = new StringOption("RESTPATH", "");
    public static final StringOption RESTXQPATH = new StringOption("RESTXQPATH", "");
    public static final NumberOption PARSERESTXQ = new NumberOption("PARSERESTXQ", 3);
    public static final BooleanOption HTTPLOCAL = new BooleanOption("HTTPLOCAL", false);
    public static final NumberOption STOPPORT = new NumberOption("STOPPORT", 8985);
    public static final EnumOption<AuthMethod> AUTHMETHOD = new EnumOption<AuthMethod>("AUTHMETHOD", AuthMethod.BASIC);

    StaticOptions(boolean file) {
        super(file ? new IOFile(Prop.HOMEDIR, ".basex") : null);
        String nph;
        String pp;
        this.setSystem();
        Prop.language = this.get(LANG);
        Prop.langkeys = this.get(LANGKEYS);
        Prop.debug = this.get(DEBUG);
        String ph = this.get(PROXYHOST);
        if (!ph.isEmpty()) {
            Prop.setSystem("http.proxyHost", ph);
            Prop.setSystem("https.proxyHost", ph);
        }
        if (!(pp = Integer.toString(this.get(PROXYPORT))).equals("0")) {
            Prop.setSystem("http.proxyPort", pp);
            Prop.setSystem("https.proxyPort", pp);
        }
        if (!(nph = this.get(NONPROXYHOSTS)).isEmpty()) {
            Prop.setSystem("http.nonProxyHosts", nph);
        }
        if (this.get(IGNORECERT).booleanValue()) {
            IOUrl.ignoreCert();
        }
        if (this.get(IGNOREHOSTNAME).booleanValue()) {
            IOUrl.ignoreHostname();
        }
    }

    public IOFile dbPath(String name) {
        return new IOFile(this.get(DBPATH), name);
    }

    public String randomDbName(String db) {
        String nm;
        while (this.dbPath(nm = db + '_' + new Random().nextInt(Integer.MAX_VALUE)).exists()) {
        }
        return nm;
    }

    public IOFile dbPath() {
        return new IOFile(this.get(DBPATH));
    }

    public boolean dbExists(String db) {
        return !db.isEmpty() && this.dbPath(db).exists();
    }

    public static enum AuthMethod {
        BASIC,
        DIGEST,
        CUSTOM;


        public String toString() {
            String name = this.name();
            return name.substring(0, 1) + name.substring(1).toLowerCase(Locale.ENGLISH);
        }
    }
}

