/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.gui.view.map.MapRect;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;

final class MapRects
implements Iterable<MapRect> {
    MapRect[] list = new MapRect[8];
    MapRect[] sorted;
    int size;

    MapRects() {
        this(8);
    }

    private MapRects(int is) {
        this.list = new MapRect[is];
    }

    void add(MapRect v) {
        if (this.size == this.list.length) {
            this.list = Array.copy(this.list, new MapRect[Array.newSize(this.size)]);
        }
        this.list[this.size++] = v;
    }

    void add(MapRects v) {
        for (MapRect m : v) {
            this.add(m);
        }
    }

    MapRect get(int i) {
        return this.list[i];
    }

    void reset() {
        this.size = 0;
    }

    int find(int p) {
        if (this.sorted == null) {
            this.sort();
        }
        int l = 0;
        int h = this.size - 1;
        while (l <= h) {
            int m = l + h >>> 1;
            int c = this.sorted[m].pre - p;
            if (c == 0) {
                return m;
            }
            if (c < 0) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return -1;
    }

    private void sort() {
        int i = Integer.MIN_VALUE;
        for (MapRect r : this) {
            if (i > r.pre) {
                this.sorted = Arrays.copyOf(this.list, this.size);
                Arrays.sort(this.sorted);
                return;
            }
            i = r.pre;
        }
        this.sorted = this.list;
    }

    @Override
    public Iterator<MapRect> iterator() {
        return new ArrayIterator<MapRect>(this.list, this.size);
    }

    MapRects copy() {
        MapRects rects = new MapRects(this.size);
        rects.add(this);
        return rects;
    }
}

