/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.name;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.MetaData;
import org.basex.index.Index;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.stats.Stats;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.util.IndexCosts;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class Names
extends TokenSet
implements Index {
    private Stats[] stats;
    private final MetaData meta;

    public Names(MetaData meta) {
        this.meta = meta;
        this.stats = new Stats[8];
    }

    public Names(DataInput in, MetaData meta) throws IOException {
        super(in);
        this.meta = meta;
        this.stats = new Stats[this.keys.length];
        for (int id = 1; id < this.size; ++id) {
            this.stats[id] = new Stats(in);
        }
    }

    public void init() {
        for (int id = 1; id < this.size; ++id) {
            this.stats[id] = new Stats();
        }
    }

    public int index(byte[] name) {
        return this.index(name, null);
    }

    public int index(byte[] name, byte[] value) {
        int id = this.put(name);
        Stats s = this.stats[id];
        if (s == null) {
            this.stats[id] = s = new Stats();
        }
        if (value != null) {
            s.add(value, this.meta);
        }
        ++s.count;
        return id;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        for (int id = 1; id < this.size; ++id) {
            Stats s = this.stats[id];
            if (s == null) {
                this.stats[id] = s = new Stats();
            }
            s.write(out);
        }
    }

    public Stats stats(int id) {
        return this.stats[id];
    }

    @Override
    public byte[] info(MainOptions options) {
        int[] tl = new int[this.size];
        tl[0] = 0;
        int len = 0;
        for (int id = 1; id < this.size; ++id) {
            if (len < this.keys[id].length) {
                len = this.keys[id].length;
            }
            if (this.stats[id] == null) continue;
            tl[id] = this.stats[id].count;
        }
        len += 2;
        int[] ids = Array.createOrder(tl, false);
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: Hash" + Text.NL);
        tb.add("- Entries: " + (this.size - 1) + Text.NL);
        for (int i = 0; i < this.size - 1; ++i) {
            int id = ids[i];
            if (this.stats[id] == null) continue;
            byte[] key = this.keys[id];
            tb.add("  ").add(key);
            int kl = len - key.length;
            for (int k = 0; k < kl; ++k) {
                tb.add(32);
            }
            tb.add(this.stats[id] + Text.NL);
        }
        return tb.finish();
    }

    @Override
    public EntryIterator entries(IndexEntries entries) {
        return new EntryIterator(){
            int c;

            @Override
            public byte[] next() {
                return ++this.c < Names.this.size ? Names.this.keys[this.c] : null;
            }

            @Override
            public int count() {
                return ((Names)Names.this).stats[this.c].count;
            }
        };
    }

    @Override
    protected void rehash(int s) {
        super.rehash(s);
        this.stats = Array.copy(this.stats, new Stats[s]);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean drop() {
        throw Util.notExpected();
    }

    @Override
    public IndexIterator iter(IndexToken token) {
        throw Util.notExpected();
    }

    @Override
    public IndexCosts costs(IndexToken token) {
        throw Util.notExpected();
    }
}

