/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.util.ft.FTPos;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class SAXSerializer
extends Serializer
implements XMLReader {
    private final Item item;
    private ContentHandler contentHandler;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private ErrorHandler errorHandler;
    private LexicalHandler lexicalHandler;
    private final Atts attributes = new Atts();
    private NSDecl namespaces;

    public SAXSerializer(Item item) {
        this.item = item;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void parse(InputSource input) throws SAXException {
        this.parse("");
    }

    @Override
    public void parse(String id) throws SAXException {
        try {
            this.contentHandler.startDocument();
            this.serialize(this.item);
            this.contentHandler.endDocument();
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void setContentHandler(ContentHandler ch) {
        this.contentHandler = ch;
    }

    public void setLexicalHandler(LexicalHandler lh) {
        this.lexicalHandler = lh;
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
        this.entityResolver = er;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler dtd) {
        this.dtdHandler = dtd;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException();
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException();
    }

    @Override
    protected void startOpen(QNm name) {
        this.namespaces = new NSDecl(this.namespaces);
        this.attributes.reset();
    }

    @Override
    protected void attribute(byte[] name, byte[] value, boolean standalone) {
        byte[] prefix = null;
        if (Token.startsWith(name, Token.XMLNS)) {
            if (name.length == 5) {
                prefix = Token.EMPTY;
            } else if (name[5] == 58) {
                prefix = Token.substring(name, 6);
            }
        }
        if (prefix != null) {
            this.namespaces.put(prefix, value);
        } else {
            this.attributes.add(name, value);
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        try {
            AttributesImpl attrs = new AttributesImpl();
            int as = this.attributes.size();
            for (int a = 0; a < as; ++a) {
                byte[] name = this.attributes.name(a);
                String uri = Token.string(this.namespaces.get(Token.prefix(name)));
                String lname = Token.string(Token.local(name));
                String rname = Token.string(name);
                String value = Token.string(this.attributes.value(a));
                attrs.addAttribute(uri, lname, rname, null, value);
            }
            String uri = Token.string(this.namespaces.get(this.elem.prefix()));
            String lname = Token.string(this.elem.local());
            String rname = Token.string(this.elem.string());
            this.contentHandler.startElement(uri, lname, rname, attrs);
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        try {
            String uri = Token.string(this.namespaces.get(this.elem.prefix()));
            String lname = Token.string(this.elem.local());
            String rname = Token.string(this.elem.string());
            this.contentHandler.endElement(uri, lname, rname);
            this.namespaces = this.namespaces.getParent();
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    protected void text(byte[] value, FTPos ftp) throws IOException {
        try {
            String s = Token.string(value);
            char[] c = s.toCharArray();
            this.contentHandler.characters(c, 0, c.length);
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    protected void comment(byte[] value) throws IOException {
        if (this.lexicalHandler != null) {
            try {
                String s = Token.string(value);
                char[] c = s.toCharArray();
                this.lexicalHandler.comment(c, 0, c.length);
            }
            catch (SAXException ex) {
                throw new IOException(ex);
            }
        }
    }

    @Override
    protected void pi(byte[] name, byte[] value) throws IOException {
        try {
            this.contentHandler.processingInstruction(Token.string(name), Token.string(value));
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }

    private static final class NSDecl {
        private final NSDecl parent;
        private Atts decls;

        private NSDecl(NSDecl parent) {
            this.parent = parent;
        }

        private NSDecl getParent() {
            return this.parent;
        }

        private void put(byte[] prefix, byte[] uri) {
            if (this.decls == null) {
                this.decls = new Atts();
            }
            this.decls.add(prefix, uri);
        }

        private byte[] get(byte[] prefix) {
            NSDecl c = this;
            while (c != null) {
                byte[] ns;
                if (c.decls != null && (ns = c.decls.value(prefix)) != null) {
                    return ns;
                }
                c = c.parent;
            }
            return Token.EMPTY;
        }
    }
}

