/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial.csv;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.io.parse.csv.CsvXQueryConverter;
import org.basex.io.serial.SerializerOptions;
import org.basex.io.serial.csv.CsvSerializer;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.value.Value;
import org.basex.query.value.array.Array;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.util.list.TokenList;

public final class CsvXQuerySerializer
extends CsvSerializer {
    public CsvXQuerySerializer(OutputStream os, SerializerOptions opts) throws IOException {
        super(os, opts);
    }

    @Override
    public void serialize(Item item) throws IOException {
        if (this.sep && this.level == 0) {
            this.out.print(32);
        }
        if (!(item instanceof Map)) {
            throw QueryError.CSV_SERIALIZE_X.getIO("Top level must be a map; " + item.type + " found");
        }
        Map m = (Map)item;
        TokenList tl = new TokenList();
        try {
            if (this.header) {
                if (!m.contains(CsvXQueryConverter.NAMES, null)) {
                    throw QueryError.CSV_SERIALIZE_X.getIO("Map has no 'names' key");
                }
                this.record(m.get(CsvXQueryConverter.NAMES, null), tl);
            }
            if (!m.contains(CsvXQueryConverter.RECORDS, null)) {
                throw QueryError.CSV_SERIALIZE_X.getIO("Map has no 'records' key");
            }
            for (Item record : m.get(CsvXQueryConverter.RECORDS, null)) {
                this.record(record, tl);
            }
        }
        catch (QueryException ex) {
            throw new QueryIOException(ex);
        }
        this.sep = true;
    }

    private void record(Value line, TokenList tl) throws QueryException, IOException {
        if (!(line instanceof Array)) {
            throw QueryError.CSV_SERIALIZE_X.getIO("Array expected; " + line.type + " found");
        }
        for (Value entry : ((Array)line).members()) {
            if (!(entry instanceof AStr)) {
                throw QueryError.CSV_SERIALIZE_X.getIO("Single item expected; " + entry.type + " found");
            }
            tl.add(((Item)entry).string(null));
        }
        this.record(tl);
    }
}

