/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Set;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.list.ANodeBuilder;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Except
extends Set {
    public Except(InputInfo info, Expr[] exprs) {
        super(info, exprs);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        super.optimize(cc);
        ExprList list = new ExprList(this.exprs.length);
        for (Expr expr : this.exprs) {
            if (expr == Empty.SEQ) {
                if (list.isEmpty()) {
                    return cc.emptySeq(this);
                }
                cc.info("remove % from %", expr, this.description());
                continue;
            }
            list.add(expr);
        }
        if (list.size() == 1 && this.iterable) {
            return (Expr)list.get(0);
        }
        this.exprs = (Expr[])list.finish();
        return this;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        Except ex = new Except(this.info, Except.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
        ex.iterable = this.iterable;
        return this.copyType(ex);
    }

    @Override
    protected ANodeBuilder eval(Iter[] iters, QueryContext qc) throws QueryException {
        Item item;
        ANodeBuilder list = new ANodeBuilder();
        while ((item = qc.next(iters[0])) != null) {
            list.add(this.toNode(item));
        }
        list.check();
        int el = this.exprs.length;
        for (int e = 1; e < el && !list.isEmpty(); ++e) {
            Item item2;
            Iter iter = iters[e];
            while ((item2 = qc.next(iter)) != null) {
                list.delete(this.toNode(item2));
            }
        }
        return list;
    }

    @Override
    protected NodeIter iter(Iter[] iters, QueryContext qc) {
        return new Set.SetIter(qc, iters){

            @Override
            public ANode next() throws QueryException {
                int i;
                int il;
                if (this.nodes == null) {
                    il = this.iter.length;
                    this.nodes = new ANode[il];
                    for (i = 0; i < il; ++i) {
                        this.next(i);
                    }
                }
                il = this.nodes.length;
                for (i = 1; i < il; ++i) {
                    if (this.nodes[0] == null) {
                        return null;
                    }
                    if (this.nodes[i] == null) continue;
                    int d = this.nodes[0].diff(this.nodes[i]);
                    if (d < 0 && i + 1 == il) break;
                    if (d == 0) {
                        this.next(0);
                        i = 0;
                    }
                    if (d <= 0) continue;
                    this.next(i--);
                }
                ANode temp = this.nodes[0];
                this.next(0);
                return temp;
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Except && super.equals(obj);
    }
}

