/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Or;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.Function;
import org.basex.query.func.fn.FnBoolean;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class If
extends Arr {
    private Expr cond;

    public If(InputInfo info, Expr cond, Expr branch1, Expr branch2) {
        super(info, SeqType.ITEM_ZM, branch1, branch2);
        this.cond = cond;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.cond);
        this.checkAllUp(this.exprs);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int[] branches;
        int[] nArray;
        this.cond = this.cond.compile(cc);
        if (this.cond instanceof Value) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = this.branch(cc.qc);
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        for (int b : branches = nArray) {
            try {
                this.exprs[b] = this.exprs[b].compile(cc);
            }
            catch (QueryException ex) {
                this.exprs[b] = cc.error(ex, this);
            }
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.cond = this.cond.optimizeEbv(cc);
        if (this.cond instanceof Value) {
            return cc.replaceWith(this, this.exprs[this.branch(cc.qc)]);
        }
        if (this.exprs[0].equals(this.exprs[1])) {
            return cc.replaceWith(this, this.exprs[0]);
        }
        if (this.cond.isFunction(Function.NOT)) {
            cc.info("swap operands: %", this);
            this.cond = ((Arr)this.cond).exprs[0];
            Expr tmp = this.exprs[0];
            this.exprs[0] = this.exprs[1];
            this.exprs[1] = tmp;
        }
        SeqType st1 = this.exprs[0].seqType();
        SeqType st2 = this.exprs[1].seqType();
        if (st1.eq(SeqType.BLN_O) && st2.eq(SeqType.BLN_O)) {
            Expr a = this.cond;
            Expr b = this.exprs[0];
            Expr c = this.exprs[1];
            if (b == Bln.TRUE) {
                if (c == Bln.FALSE) {
                    return cc.replaceWith(this, FnBoolean.get(a, this.info, cc.sc()));
                }
                return cc.replaceWith(this, new Or(this.info, a, c).optimize(cc));
            }
            if (c == Bln.TRUE) {
                if (b == Bln.FALSE) {
                    return cc.replaceWith(this, cc.function(Function.NOT, this.info, a));
                }
                Expr expr = new Or(this.info, cc.function(Function.NOT, this.info, a), b).optimize(cc);
                return cc.replaceWith(this, expr);
            }
            if (b == Bln.FALSE) {
                Expr expr = new And(this.info, cc.function(Function.NOT, this.info, a), c).optimize(cc);
                return cc.replaceWith(this, expr);
            }
            if (c == Bln.FALSE) {
                return cc.replaceWith(this, new And(this.info, a, b).optimize(cc));
            }
        }
        this.exprType.assign(st1.union(st2));
        return this;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.exprs[this.branch(qc)].iter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.exprs[this.branch(qc)].value(qc);
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.exprs[this.branch(qc)].item(qc, this.info);
    }

    private int branch(QueryContext qc) throws QueryException {
        return this.cond.ebv(qc, this.info).bool(this.info) ? 0 : 1;
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.cond.has(flags) || super.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        return this.cond.removable(var) && super.removable(var);
    }

    @Override
    public VarUsage count(Var var) {
        return this.cond.count(var).plus(VarUsage.maximum(var, this.exprs));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = false;
        Expr sub = this.cond.inline(var, ex, cc);
        if (sub != null) {
            this.cond = sub;
            changed = true;
        }
        int es = this.exprs.length;
        for (int e = 0; e < es; ++e) {
            Expr exp;
            try {
                exp = this.exprs[e].inline(var, ex, cc);
            }
            catch (QueryException qe) {
                exp = cc.error(qe, this);
            }
            if (exp == null) continue;
            this.exprs[e] = exp;
            changed = true;
        }
        return changed ? this.optimize(cc) : null;
    }

    @Override
    public If copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new If(this.info, this.cond.copy(cc, vm), this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm)));
    }

    @Override
    public boolean isVacuous() {
        return this.exprs[0].isVacuous() && this.exprs[1].isVacuous();
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        for (Expr expr : this.exprs) {
            expr.markTailCalls(cc);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.cond.accept(visitor) && super.accept(visitor);
    }

    @Override
    public int exprSize() {
        int size = this.cond.exprSize();
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size;
    }

    @Override
    public Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        boolean changed = false;
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            Expr expr = this.exprs[e];
            try {
                expr = tc.check(expr, cc);
            }
            catch (QueryException qe) {
                expr = cc.error(qe, expr);
            }
            if (expr == this.exprs[e]) continue;
            changed = true;
            this.exprs[e] = expr;
        }
        return changed ? this.optimize(cc) : this;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof If && this.cond.equals(((If)obj).cond) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        If.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.cond, this.exprs});
    }

    @Override
    public String toString() {
        return "if(" + this.cond + ") " + "then" + ' ' + this.exprs[0] + ' ' + "else" + ' ' + this.exprs[1];
    }
}

