/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.func.Function;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Pos
extends Arr {
    private Pos(InputInfo info, Expr min, Expr max) {
        super(info, SeqType.BLN_O, min, max);
    }

    public static Expr get(Cmp cmp, CmpV.OpV op, InputInfo info, CompileContext cc) throws QueryException {
        Expr cmp1 = cmp.exprs[0];
        Expr cmp2 = cmp.exprs[1];
        if (!cmp1.isFunction(Function.POSITION)) {
            return cmp;
        }
        Expr min = null;
        Expr max = null;
        SeqType st1 = cmp1.seqType();
        SeqType st2 = cmp2.seqType();
        if (cmp2.isSimple()) {
            if (cmp2 instanceof Range && op == CmpV.OpV.EQ) {
                Range range = (Range)cmp2;
                Expr start = range.exprs[0];
                Expr end = range.exprs[1];
                if (st1.type.instanceOf(AtomType.ITR) && st2.type.instanceOf(AtomType.ITR)) {
                    min = start;
                    max = start.equals(end) ? start : end;
                }
            } else if (st2.oneNoArray()) {
                switch (op) {
                    case EQ: {
                        min = cmp2;
                        max = cmp2;
                        break;
                    }
                    case GE: {
                        min = cmp2;
                        max = Int.MAX;
                        break;
                    }
                    case GT: {
                        min = new Arith(info, st2.type.instanceOf(AtomType.ITR) ? cmp2 : cc.function(Function.FLOOR, info, cmp2), (Expr)Int.ONE, Calc.PLUS);
                        max = Int.MAX;
                        break;
                    }
                    case LE: {
                        min = Int.ONE;
                        max = cmp2;
                        break;
                    }
                    case LT: {
                        min = Int.ONE;
                        max = new Arith(info, st2.type.instanceOf(AtomType.ITR) ? cmp2 : cc.function(Function.CEILING, info, cmp2), (Expr)Int.ONE, Calc.MINUS);
                        break;
                    }
                }
            }
        }
        return min == null ? cmp : new Pos(info, min, max);
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        this.ctxValue(qc);
        Item item1 = this.exprs[0].atomItem(qc, this.info);
        if (item1 == null) {
            return Bln.FALSE;
        }
        long pos = qc.focus.pos;
        double start = this.toDouble(item1);
        if (this.eq()) {
            return Bln.get((double)pos == start);
        }
        Item item2 = this.exprs[1].atomItem(qc, this.info);
        if (item2 == null) {
            return Bln.FALSE;
        }
        double end = this.toDouble(item2);
        return Bln.get((double)pos >= start && (double)pos <= end);
    }

    @Override
    public Pos copy(CompileContext cc, IntObjMap<Var> vm) {
        return new Pos(this.info, this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm));
    }

    Expr intersect(Pos pos, InputInfo ii) {
        Expr[] r1 = this.exprs;
        Expr[] r2 = pos.exprs;
        if (!this.eq() && !pos.eq()) {
            Expr max;
            Expr min;
            Expr expr = r1[0] == Int.ONE ? r2[0] : (min = r2[0] == Int.ONE ? r1[0] : null);
            Expr expr2 = r1[1] == Int.MAX ? r2[1] : (max = r2[1] == Int.MAX ? r1[1] : null);
            if (min != null && max != null) {
                return new Pos(ii, min, max);
            }
        }
        return null;
    }

    private boolean eq() {
        Expr[] ex = this.exprs;
        return ex[0] == ex[1];
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.POS.in(flags);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Pos && super.equals(obj);
    }

    @Override
    public String description() {
        return "positional access";
    }

    @Override
    public void plan(FElem plan) {
        Pos.addPlan(plan, this.planElem(new Object[0]), this.exprs);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(").append("position() = ").append(this.exprs[0]);
        if (!this.eq()) {
            sb.append(" to ").append(this.exprs[1]);
        }
        return sb.append(")").toString();
    }
}

