/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.CName;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FPI;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.IntObjMap;

public final class CPI
extends CName {
    public CPI(StaticContext sc, InputInfo info, Expr name, Expr value) {
        super("processing-instruction", sc, info, SeqType.PI_O, name, value);
    }

    @Override
    public FPI item(QueryContext qc, InputInfo ii) throws QueryException {
        QNm qnm;
        Item item = this.checkNoEmpty(this.name.atomItem(qc, this.info), AtomType.QNM);
        Type type = item.type;
        if (type == AtomType.QNM) {
            qnm = (QNm)item;
        } else {
            if (!type.isStringOrUntyped() || type == AtomType.URI) {
                throw QueryError.CPIWRONG_X_X.get(this.info, type, item);
            }
            byte[] nm = Token.trim(item.string(this.info));
            if (Token.eq(Token.lc(nm), Token.XML)) {
                throw QueryError.CPIXML_X.get(this.info, new Object[]{nm});
            }
            if (!XMLToken.isNCName(nm)) {
                throw QueryError.CPIINVAL_X.get(this.info, new Object[]{nm});
            }
            qnm = new QNm(nm);
        }
        byte[] v = this.atomValue(qc);
        int i = -1;
        int vl = v.length;
        while (++i < vl && v[i] >= 0 && v[i] <= 32) {
        }
        v = Token.substring(v, i);
        return new FPI(qnm, FPI.parse(v, this.info));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CPI && super.equals(obj);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new CPI(this.sc, this.info, this.name.copy(cc, vm), this.exprs[0].copy(cc, vm));
    }
}

