/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import org.basex.core.Text;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.Closure;
import org.basex.query.func.Functions;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.StaticFuncCall;
import org.basex.query.func.TypedFunc;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;
import org.basex.util.similarity.Levenshtein;

public final class StaticFuncs
extends ExprInfo {
    private final TokenObjMap<FuncCache> funcs = new TokenObjMap();

    static byte[] signature(QNm name, long arity) {
        return new TokenBuilder(name.prefixId()).add(35).addLong(arity).finish();
    }

    public StaticFunc declare(AnnList anns, QNm nm, Var[] params, SeqType type, Expr expr, String doc, VarScope vs, InputInfo info) throws QueryException {
        byte[] uri = nm.uri();
        if (uri.length == 0) {
            throw QueryError.FUNNONS_X.get(info, new Object[]{nm.string()});
        }
        if (NSGlobal.reserved(uri) || Functions.get().getBuiltIn(nm) != null) {
            throw QueryError.FNRESERVED_X.get(info, new Object[]{nm.string()});
        }
        StaticFunc sf = new StaticFunc(anns, nm, params, type, expr, doc, vs, info);
        byte[] sig = sf.id();
        FuncCache fc = this.funcs.get(sig);
        if (fc != null) {
            fc.setFunc(sf);
        } else {
            this.funcs.put(sig, new FuncCache(sf));
        }
        return sf;
    }

    TypedFunc funcCall(QNm name, Expr[] args, StaticContext sc, InputInfo info) throws QueryException {
        FuncCache fc = this.funcs.get(StaticFuncs.signature(name, args.length));
        return fc == null ? null : fc.newCall(name, args, sc, info);
    }

    TypedFunc undeclaredFuncCall(QNm name, Expr[] args, StaticContext sc, InputInfo info) throws QueryException {
        QueryException qe;
        if (NSGlobal.reserved(name.uri()) && (qe = this.similarError(name, info)) != null) {
            throw qe;
        }
        byte[] sig = StaticFuncs.signature(name, args.length);
        if (!this.funcs.contains(sig)) {
            this.funcs.put(sig, new FuncCache(null));
        }
        return this.funcCall(name, args, sc, info);
    }

    public void registerFuncLiteral(Closure literal) {
        byte[] sig = StaticFuncs.signature(literal.funcName(), literal.arity());
        FuncCache cache = this.funcs.get(sig);
        if (cache == null) {
            cache = new FuncCache(null);
            this.funcs.put(sig, cache);
        }
        cache.literals.add(literal);
    }

    public void check(QueryContext qc) throws QueryException {
        for (FuncCache fc : this.funcs.values()) {
            StaticFuncCall call;
            StaticFuncCall staticFuncCall = call = fc.calls.isEmpty() ? null : fc.calls.get(0);
            if (fc.func == null) {
                IntList arities = new IntList();
                for (FuncCache ofc : this.funcs.values()) {
                    if (fc == ofc || ofc.func == null || !call.name.eq(ofc.name())) continue;
                    arities.add(ofc.func.arity());
                }
                if (!arities.isEmpty()) {
                    throw Functions.wrongArity(call.name.string(), call.exprs.length, arities, call.info);
                }
                QNm nm = call.name;
                QueryException qe = this.similarError(nm, call.info);
                throw qe != null ? qe : QueryError.WHICHFUNC_X.get(call.info, new Object[]{nm.prefixString()});
            }
            if (call == null) continue;
            if (fc.func.expr == null) {
                throw QueryError.FUNCNOIMPL_X.get(call.info, new Object[]{call.name.prefixString()});
            }
            qc.updating |= fc.func.updating;
        }
    }

    public void checkUp() throws QueryException {
        for (FuncCache fc : this.funcs.values()) {
            fc.func.checkUp();
        }
    }

    public void compile(CompileContext cc) {
        this.compile(cc, false);
    }

    public void compile(CompileContext cc, boolean all) {
        for (FuncCache fc : this.funcs.values()) {
            if (!all && fc.calls.isEmpty()) continue;
            fc.func.comp(cc);
        }
    }

    public StaticFunc get(QNm name, long arity) {
        FuncCache fc = this.funcs.get(StaticFuncs.signature(name, arity));
        return fc != null ? fc.func : null;
    }

    public QueryException similarError(QNm name, InputInfo info) {
        QueryException qe = null;
        Levenshtein ls = new Levenshtein();
        byte[] nm = Token.lc(name.local());
        for (FuncCache fc : this.funcs.values()) {
            StaticFunc sf = fc.func;
            if (sf == null || sf.expr == null || !ls.similar(nm, Token.lc(sf.name.local()))) continue;
            qe = QueryError.FUNCSIMILAR_X_X.get(info, name.prefixString(), sf.name.prefixString());
            break;
        }
        if (qe == null) {
            qe = Functions.get().similarError(name, info);
        }
        return qe;
    }

    public StaticFunc[] funcs() {
        int fs = this.funcs.size();
        StaticFunc[] sf = new StaticFunc[fs];
        int i = 0;
        for (FuncCache fc : this.funcs.values()) {
            sf[i++] = fc.func;
        }
        return sf;
    }

    @Override
    public void plan(FElem plan) {
        if (!this.funcs.isEmpty()) {
            FElem elem = this.planElem(new Object[0]);
            plan.add(elem);
            for (StaticFunc f : this.funcs()) {
                if (f == null) continue;
                f.plan(elem);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (FuncCache fc : this.funcs.values()) {
            if (fc.func == null || !fc.func.compiled()) continue;
            sb.append(fc.func).append(Text.NL);
        }
        return sb.toString();
    }

    private static class FuncCache {
        final ArrayList<StaticFuncCall> calls = new ArrayList(0);
        final ArrayList<Closure> literals = new ArrayList(0);
        StaticFunc func;

        FuncCache(StaticFunc func) {
            this.func = func;
        }

        public void setFunc(StaticFunc sf) throws QueryException {
            if (this.func != null) {
                throw QueryError.FUNCDEFINED_X.get(sf.info, new Object[]{sf.name.string()});
            }
            this.func = sf;
            for (StaticFuncCall call : this.calls) {
                call.init(sf);
            }
            FuncType ft = sf.funcType();
            for (Closure literal : this.literals) {
                literal.adoptSignature(ft);
            }
        }

        public TypedFunc newCall(QNm name, Expr[] args, StaticContext sc, InputInfo info) throws QueryException {
            StaticFuncCall call = new StaticFuncCall(name, args, sc, info);
            this.calls.add(call);
            return this.func == null ? new TypedFunc(call, new AnnList()) : new TypedFunc(call.init(this.func), this.func.anns);
        }

        public QNm name() {
            return this.func != null ? this.func.name : this.calls.get((int)0).name;
        }
    }
}

