/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.user;

import org.basex.core.users.User;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.user.UserFn;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.UserPermUpdate;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class UserDrop
extends UserFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        User user = this.toSafeUser(0, qc);
        StringList patterns = this.toPatterns(1, qc);
        if (user.name().equals("admin")) {
            throw QueryError.USER_ADMIN.get(this.info, new Object[0]);
        }
        qc.updates().add(new Drop(user, patterns, qc, this.info), qc);
        return null;
    }

    private static final class Drop
    extends UserPermUpdate {
        private Drop(User user, StringList patterns, QueryContext qc, InputInfo info) throws QueryException {
            super(UpdateType.USERDROP, user, null, patterns, qc, info);
        }

        @Override
        public void apply() {
            boolean global = false;
            for (String pattern : this.patterns) {
                global |= pattern.isEmpty();
            }
            if (global) {
                this.users.drop(this.user);
            } else {
                for (String db : this.patterns) {
                    this.user.drop(db);
                }
            }
        }

        @Override
        public String operation() {
            return "dropped";
        }
    }
}

