/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.util.Arrays;
import org.basex.query.util.fingertree.NodeLike;
import org.basex.query.value.Value;
import org.basex.query.value.array.LeafNode;
import org.basex.util.Util;

final class PartialLeafNode
implements NodeLike<Value, Value> {
    final Value[] elems;

    PartialLeafNode(Value[] elems) {
        this.elems = elems;
    }

    @Override
    public int append(NodeLike<Value, Value>[] nodes, int pos) {
        if (pos == 0) {
            nodes[0] = this;
            return 1;
        }
        NodeLike<Value, Value> left = nodes[pos - 1];
        if (left instanceof PartialLeafNode) {
            Value[] ls = ((PartialLeafNode)left).elems;
            Value[] rs = this.elems;
            int l = ls.length;
            int r = rs.length;
            int n = l + r;
            Value[] vals = new Value[n];
            System.arraycopy(ls, 0, vals, 0, l);
            System.arraycopy(rs, 0, vals, l, r);
            nodes[pos - 1] = n < 8 ? new PartialLeafNode(vals) : new LeafNode(vals);
            return pos;
        }
        Value[] ls = ((LeafNode)left).values;
        int l = ls.length;
        Value[] rs = this.elems;
        int r = rs.length;
        int n = l + r;
        if (n <= 15) {
            Value[] vals = new Value[n];
            System.arraycopy(ls, 0, vals, 0, l);
            System.arraycopy(rs, 0, vals, l, r);
            nodes[pos - 1] = new LeafNode(vals);
            return pos;
        }
        int ll = n / 2;
        int rl = n - ll;
        int move = l - ll;
        Value[] newLeft = new Value[ll];
        Value[] newRight = new Value[rl];
        System.arraycopy(ls, 0, newLeft, 0, ll);
        System.arraycopy(ls, ll, newRight, 0, move);
        System.arraycopy(rs, 0, newRight, move, r);
        nodes[pos - 1] = new LeafNode(newLeft);
        nodes[pos] = new LeafNode(newRight);
        return pos + 1;
    }

    public String toString() {
        return Util.className(this) + '(' + this.elems.length + ')' + Arrays.toString(this.elems);
    }
}

