/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MergeDuplicates;
import org.basex.query.value.map.TrieBranch;
import org.basex.query.value.map.TrieLeaf;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;

final class TrieList
extends TrieNode {
    final int hash;
    final Item[] keys;
    final Value[] values;

    TrieList(int hash, Item[] keys, Value[] values) {
        super(keys.length);
        this.keys = keys;
        this.values = values;
        this.hash = hash;
        assert (this.verify());
    }

    TrieList(int hash, Item key1, Value value1, Item key2, Value value2) {
        this(hash, new Item[]{key1, key2}, new Value[]{value1, value2});
    }

    @Override
    TrieNode delete(int hs, Item key, int level, InputInfo info) throws QueryException {
        if (hs == this.hash) {
            int i = this.size;
            while (i-- > 0) {
                if (!key.sameKey(this.keys[i], info)) continue;
                if (this.size == 2) {
                    int o = i ^ 1;
                    return new TrieLeaf(hs, this.keys[o], this.values[o]);
                }
                int s = this.size - 1;
                Item[] ks = new Item[s];
                System.arraycopy(this.keys, 0, ks, 0, i);
                System.arraycopy(this.keys, i + 1, ks, i, s - i);
                Value[] vs = new Value[s];
                System.arraycopy(this.values, 0, vs, 0, i);
                System.arraycopy(this.values, i + 1, vs, i, s - i);
                return new TrieList(hs, ks, vs);
            }
        }
        return this;
    }

    @Override
    TrieNode put(int hs, Item key, Value value, int level, InputInfo info) throws QueryException {
        int used;
        int b;
        if (hs == this.hash) {
            int i = this.keys.length;
            while (i-- > 0) {
                if (!key.sameKey(this.keys[i], info)) continue;
                Value[] vs = (Value[])this.values.clone();
                vs[i] = value;
                return new TrieList(hs, this.keys, vs);
            }
            return new TrieList(this.hash, Array.add(this.keys, key), Array.add(this.values, value));
        }
        TrieNode[] ch = new TrieNode[32];
        int a = TrieList.key(hs, level);
        if (a == (b = TrieList.key(this.hash, level))) {
            ch[a] = this.put(hs, key, value, level + 1, info);
            used = 1 << a;
        } else {
            ch[a] = new TrieLeaf(hs, key, value);
            ch[b] = this;
            used = 1 << a | 1 << b;
        }
        return new TrieBranch(ch, used, this.size + 1);
    }

    @Override
    Value get(int hs, Item key, int level, InputInfo info) throws QueryException {
        if (hs == this.hash) {
            int k = this.keys.length;
            while (k-- != 0) {
                if (!key.sameKey(this.keys[k], info)) continue;
                return this.values[k];
            }
        }
        return null;
    }

    @Override
    boolean contains(int hs, Item key, int level, InputInfo info) throws QueryException {
        if (hs == this.hash) {
            int k = this.keys.length;
            while (k-- != 0) {
                if (!key.sameKey(this.keys[k], info)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    TrieNode addAll(TrieNode node, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        return node.add(this, level, merge, info, qc);
    }

    @Override
    TrieNode add(TrieLeaf leaf, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        int nu;
        int ok;
        qc.checkStop();
        if (this.hash == leaf.hash) {
            int k = this.keys.length;
            while (k-- > 0) {
                if (!leaf.key.sameKey(this.keys[k], info)) continue;
                switch (merge) {
                    case USE_FIRST: 
                    case UNSPECIFIED: {
                        Value[] uf = (Value[])this.values.clone();
                        uf[k] = leaf.value;
                        return new TrieList(this.hash, this.keys, uf);
                    }
                    case USE_LAST: {
                        return this;
                    }
                    case COMBINE: {
                        Value[] cm = (Value[])this.values.clone();
                        cm[k] = ValueBuilder.concat(leaf.value, cm[k], qc);
                        return new TrieList(this.hash, this.keys, cm);
                    }
                }
                throw QueryError.MERGE_DUPLICATE_X.get(info, leaf.key);
            }
            return new TrieList(this.hash, Array.add(this.keys, leaf.key), Array.add(this.values, leaf.value));
        }
        TrieNode[] ch = new TrieNode[32];
        int k = TrieList.key(this.hash, level);
        if (k == (ok = TrieList.key(leaf.hash, level))) {
            ch[k] = this.add(leaf, level + 1, merge, info, qc);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = leaf;
            nu = 1 << k | 1 << ok;
        }
        return new TrieBranch(ch, nu, this.size + 1);
    }

    @Override
    TrieNode add(TrieList list, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        int nu;
        int ok;
        qc.checkStop();
        if (this.hash == list.hash) {
            Item[] ks = this.keys;
            Value[] vs = this.values;
            block0: for (int i = 0; i < this.size; ++i) {
                Item ok2 = list.keys[i];
                for (Item k : this.keys) {
                    if (k.sameKey(ok2, info)) continue block0;
                }
                ks = Array.add(ks, ok2);
                vs = Array.add(vs, list.values[i]);
            }
            return ks == this.keys ? this : new TrieList(this.hash, ks, vs);
        }
        TrieNode[] ch = new TrieNode[32];
        int k = TrieList.key(this.hash, level);
        if (k == (ok = TrieList.key(list.hash, level))) {
            ch[k] = this.add(list, level + 1, merge, info, qc);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = list;
            nu = 1 << k | 1 << ok;
        }
        return new TrieBranch(ch, nu, this.size + list.size);
    }

    @Override
    TrieNode add(TrieBranch branch, int level, MergeDuplicates merge, InputInfo info, QueryContext qc) throws QueryException {
        int k = TrieList.key(this.hash, level);
        TrieNode[] ch = branch.copyKids();
        TrieNode old = ch[k];
        TrieNode trieNode = old == null ? this : old.addAll(this, level + 1, merge, info, qc);
        ch[k] = trieNode;
        return new TrieBranch(ch, branch.used | 1 << k, branch.size + this.size - (old != null ? old.size : 0));
    }

    @Override
    boolean verify() {
        try {
            for (int i = 1; i < this.size; ++i) {
                int j = i;
                while (j-- > 0) {
                    if (!this.keys[i].sameKey(this.keys[j], null)) continue;
                    return false;
                }
            }
        }
        catch (QueryException ex) {
            Util.debug(ex);
            return false;
        }
        return true;
    }

    @Override
    void keys(ItemList ks) {
        for (Item key : this.keys) {
            ks.add(key);
        }
    }

    @Override
    void values(ValueBuilder vs) {
        for (Value value : this.values) {
            vs.add(value);
        }
    }

    @Override
    void materialize(InputInfo info) throws QueryException {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i].materialize(info);
            this.values[i].materialize(info);
        }
    }

    @Override
    void forEach(ValueBuilder vb, FItem func, QueryContext qc, InputInfo info) throws QueryException {
        for (int i = 0; i < this.size; ++i) {
            vb.add(func.invokeValue(qc, info, this.keys[i], this.values[i]));
        }
    }

    @Override
    boolean instanceOf(AtomType kt, SeqType dt) {
        if (kt != null) {
            for (Value value : this.keys) {
                if (((Item)value).type.instanceOf(kt)) continue;
                return false;
            }
        }
        if (dt != null) {
            for (Value value : this.values) {
                if (dt.instance(value)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    int hash(InputInfo info) throws QueryException {
        int h = this.hash;
        int i = this.size;
        while (--i >= 0) {
            h ^= this.values[i].hash(info);
        }
        return h;
    }

    @Override
    boolean deep(InputInfo info, TrieNode node, Collation coll) throws QueryException {
        if (!(node instanceof TrieList) || this.size != node.size) {
            return false;
        }
        TrieList ol = (TrieList)node;
        block0: for (int i = 0; i < this.size; ++i) {
            Item k = this.keys[i];
            for (int j = 0; j < this.size; ++j) {
                if (!k.sameKey(ol.keys[j], info)) continue;
                if (TrieList.deep(this.values[i], ol.values[j], coll, info)) continue block0;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    StringBuilder append(StringBuilder sb, String indent) {
        sb.append(indent).append("`-- Collision (").append(Integer.toHexString(this.hash)).append("):\n");
        int kl = this.keys.length;
        for (int k = 0; k < kl; ++k) {
            sb.append(indent).append("      ").append(this.keys[k]).append(" => ");
            sb.append(this.values[k]).append('\n');
        }
        return sb;
    }

    @Override
    StringBuilder append(StringBuilder sb) {
        int i = this.size;
        while (--i >= 0 && TrieList.more(sb)) {
            sb.append(this.keys[i]).append(": ").append(this.values[i]).append(", ");
        }
        return sb;
    }
}

