/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.BitSet;
import java.util.NoSuchElementException;
import org.basex.query.QueryException;
import org.basex.query.expr.ft.FTTokens;
import org.basex.util.ft.FTIterator;
import org.basex.util.list.TokenList;

public final class FTBitapSearch {
    private final FTIterator iter;
    private final FTTokens tokens;
    private final TokenComparator cmp;
    private final BitSet[] masks;
    private final int[] sorted;
    private boolean next;
    private int pos;
    private int match;

    public FTBitapSearch(FTIterator iter, FTTokens tokens, TokenComparator cmp) {
        this.iter = iter;
        this.cmp = cmp;
        this.tokens = tokens;
        this.sorted = new int[tokens.size()];
        int count = -1;
        int sl = this.sorted.length;
        for (int s = 0; s < sl; ++s) {
            if (tokens.get(s) == null || ((TokenList)tokens.get(s)).isEmpty()) continue;
            this.sorted[++count] = s;
        }
        this.masks = new BitSet[++count];
        for (int i = 0; i < count; ++i) {
            for (int j = i; j > 0 && ((TokenList)tokens.get(this.sorted[j])).size() > ((TokenList)tokens.get(this.sorted[j - 1])).size(); --j) {
                int t = this.sorted[j];
                this.sorted[j] = this.sorted[j - 1];
                this.sorted[j - 1] = t;
            }
            this.masks[i] = new BitSet();
            this.masks[i].set(0);
        }
    }

    public boolean hasNext() throws QueryException {
        if (this.masks.length == 0) {
            return false;
        }
        if (this.next) {
            return this.pos >= 0;
        }
        this.next = true;
        while (this.iter.hasNext()) {
            byte[] current = this.iter.nextToken();
            ++this.pos;
            boolean matched = false;
            int ml = this.masks.length;
            for (int i = 0; i < ml; ++i) {
                int id = this.sorted[i];
                TokenList n = (TokenList)this.tokens.get(id);
                BitSet m = this.masks[id];
                for (int k = n.size(); k >= 1; --k) {
                    m.set(k, m.get(k - 1) && this.cmp.equal(current, (byte[])n.get(k - 1)));
                }
                if (!m.get(n.size()) || matched) continue;
                this.match = id;
                matched = true;
            }
            if (!matched) continue;
            return true;
        }
        this.pos = -1;
        return false;
    }

    public int next() throws QueryException {
        if (this.hasNext()) {
            this.next = false;
            return this.pos - ((TokenList)this.tokens.get(this.match)).size();
        }
        throw new NoSuchElementException();
    }

    public static interface TokenComparator {
        public boolean equal(byte[] var1, byte[] var2) throws QueryException;
    }
}

