/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.AInfo;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class InfoIndex
extends AInfo {
    public InfoIndex() {
        this(null);
    }

    public InfoIndex(Object type) {
        super(true, type != null && type != Commands.CmdIndexInfo.NULL ? type.toString() : "");
    }

    @Override
    protected boolean run() throws IOException {
        Data data = this.context.data();
        if (!this.args[0].isEmpty()) {
            Commands.CmdIndexInfo ci = this.getOption(Commands.CmdIndexInfo.class);
            if (ci == null) {
                return this.error(Text.UNKNOWN_CMD_X, this);
            }
            byte[] inf = InfoIndex.info(ci, data, this.options);
            this.out.print(inf);
            return inf.length != 0;
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.ELEMNAME, data, this.options));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.ATTRNAME, data, this.options));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.TEXT, data, this.options));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.ATTRIBUTE, data, this.options));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.TOKEN, data, this.options));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.FULLTEXT, data, this.options));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.PATH, data, this.options));
        this.out.print(tb.finish());
        return true;
    }

    @Override
    public void addLocks() {
        this.jc().locks.reads.add("%CONTEXT");
    }

    private static byte[] info(Commands.CmdIndexInfo idx, Data data, MainOptions options) {
        switch (idx) {
            case ELEMNAME: {
                return InfoIndex.info(Text.ELEMENTS, IndexType.ELEMNAME, data, options, true);
            }
            case ATTRNAME: {
                return InfoIndex.info(Text.ATTRIBUTES, IndexType.ATTRNAME, data, options, true);
            }
            case PATH: {
                return InfoIndex.info(Text.PATH_INDEX, IndexType.PATH, data, options, true);
            }
            case TEXT: {
                return InfoIndex.info(Text.TEXT_INDEX, IndexType.TEXT, data, options, data.meta.textindex);
            }
            case ATTRIBUTE: {
                return InfoIndex.info(Text.ATTRIBUTE_INDEX, IndexType.ATTRIBUTE, data, options, data.meta.attrindex);
            }
            case TOKEN: {
                return InfoIndex.info(Text.TOKEN_INDEX, IndexType.TOKEN, data, options, data.meta.tokenindex);
            }
            case FULLTEXT: {
                return InfoIndex.info(Text.FULLTEXT_INDEX, IndexType.FULLTEXT, data, options, data.meta.ftindex);
            }
        }
        return Token.token("- " + Text.NOT_AVAILABLE);
    }

    private static byte[] info(String desc, IndexType it, Data data, MainOptions options, boolean avl) {
        TokenBuilder tb = new TokenBuilder(desc).add(Text.NL);
        if (avl) {
            tb.add(data.info(it, options));
        } else {
            tb.add("- ").addExt(Text.NOT_AVAILABLE, new Object[]{it}).add(Text.NL);
        }
        return tb.add(Text.NL).finish();
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.INFO) + " " + (Object)((Object)Commands.CmdInfo.INDEX)).args();
    }
}

