/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.value.node.FElem;
import org.basex.util.XMLToken;

public final class JsonDirectConverter
extends JsonXmlConverter {
    private final boolean lax;
    private byte[] name = JsonConstants.JSON;

    JsonDirectConverter(JsonParserOptions opts) {
        super(opts);
        this.lax = this.jopts.get(JsonOptions.LAX);
    }

    @Override
    void openObject() {
        this.curr = this.addElem(JsonConstants.OBJECT);
    }

    @Override
    void openPair(byte[] key, boolean add) {
        this.name = XMLToken.encode(key, this.lax);
    }

    @Override
    void closePair(boolean add) {
    }

    @Override
    void closeObject() {
        FElem par = (FElem)this.curr.parent();
        if (par != null) {
            this.curr = par;
        }
    }

    @Override
    void openArray() {
        this.curr = this.addElem(JsonConstants.ARRAY);
    }

    @Override
    void openItem() {
        this.name = JsonConstants.VALUE;
    }

    @Override
    void closeItem() {
    }

    @Override
    void closeArray() {
        this.closeObject();
    }

    @Override
    public void numberLit(byte[] value) {
        this.addElem(JsonConstants.NUMBER).add(value);
    }

    @Override
    public void stringLit(byte[] value) {
        this.addElem(JsonConstants.STRING).add(value);
    }

    @Override
    public void nullLit() {
        this.addElem(JsonConstants.NULL);
    }

    @Override
    public void booleanLit(byte[] value) {
        this.addElem(JsonConstants.BOOLEAN).add(value);
    }

    private FElem addElem(byte[] type) {
        FElem elem = new FElem(this.name);
        this.addType(elem, elem.name(), type);
        if (this.curr != null) {
            this.curr.add(elem);
        } else {
            this.curr = elem;
        }
        this.name = null;
        return elem;
    }
}

