/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.ByteList;

public final class TypeswitchGroup
extends Single {
    final Var var;
    private SeqType[] types;

    public TypeswitchGroup(InputInfo info, Var var, SeqType[] types, Expr expr) {
        super(info, expr, SeqType.ITEM_ZM);
        this.var = var;
        this.types = types;
    }

    @Override
    public Expr compile(CompileContext cc) {
        try {
            super.compile(cc);
        }
        catch (QueryException ex) {
            this.expr = cc.error(ex, this.expr);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        return this.adoptType(this.expr);
    }

    void opt(CompileContext cc, Value value) throws QueryException {
        if (this.var == null) {
            return;
        }
        Expr ex = this.expr.inline(this.var, this.var.checkType(value, cc.qc, true), cc);
        if (ex != null) {
            this.expr = ex;
        }
    }

    boolean removeTypes(CompileContext cc, ArrayList<SeqType> cache) {
        if (this.types.length == 0) {
            return true;
        }
        ArrayList<SeqType> tmp = new ArrayList<SeqType>();
        for (SeqType st : this.types) {
            if (cache.contains(st)) {
                cc.info("remove % from %", st, this.description());
                continue;
            }
            tmp.add(st);
            cache.add(st);
        }
        if (this.types.length != tmp.size()) {
            this.types = tmp.toArray(new SeqType[tmp.size()]);
        }
        return this.types.length != 0;
    }

    @Override
    public Expr inline(Var v, Expr ex, CompileContext cc) {
        try {
            return super.inline(v, ex, cc);
        }
        catch (QueryException qe) {
            this.expr = cc.error(qe, this.expr);
            return this;
        }
    }

    @Override
    public TypeswitchGroup copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new TypeswitchGroup(this.info, cc.copy(this.var, vm), (SeqType[])this.types.clone(), this.expr.copy(cc, vm)));
    }

    boolean matches(Value val) {
        if (this.types.length == 0) {
            return true;
        }
        for (SeqType st : this.types) {
            if (!st.instance(val)) continue;
            return true;
        }
        return false;
    }

    Iter iter(QueryContext qc, Value seq) throws QueryException {
        if (!this.matches(seq)) {
            return null;
        }
        if (this.var == null) {
            return this.expr.iter(qc);
        }
        qc.set(this.var, seq);
        return this.expr.value(qc).iter();
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        this.expr.markTailCalls(cc);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && (this.var == null || visitor.declared(this.var));
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeswitchGroup)) {
            return false;
        }
        TypeswitchGroup tg = (TypeswitchGroup)obj;
        return Array.equals(this.types, tg.types) && this.var.equals(tg.var) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem(new Object[0]);
        if (this.types.length == 0) {
            elem.add(TypeswitchGroup.planAttr(Token.token("default"), Token.TRUE));
        } else {
            ByteList bl = new ByteList();
            for (SeqType st : this.types) {
                if (!bl.isEmpty()) {
                    bl.add(124);
                }
                bl.add(Token.token(st.toString()));
            }
            elem.add(TypeswitchGroup.planAttr(Token.token("case"), bl.finish()));
        }
        if (this.var != null) {
            elem.add(TypeswitchGroup.planAttr("var", Token.token(this.var.toString())));
        }
        this.expr.plan(elem);
        plan.add(elem);
    }

    @Override
    public String toString() {
        int tl = this.types.length;
        TokenBuilder tb = new TokenBuilder(tl == 0 ? "default" : "case");
        if (this.var != null) {
            tb.add(32).add(this.var.toString());
            if (tl != 0) {
                tb.add(32).add("as");
            }
        }
        if (tl != 0) {
            for (int t = 0; t < tl; ++t) {
                if (t > 0) {
                    tb.add(" |");
                }
                tb.add(32).add(this.types[t].toString());
            }
        }
        return tb.add(" return " + this.expr).toString();
    }
}

