/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.func.Closure;
import org.basex.query.func.FuncLit;
import org.basex.query.func.Function;
import org.basex.query.func.JavaFunction;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.TypedFunc;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.similarity.Levenshtein;

public final class Functions
extends TokenSet {
    private static final Functions INSTANCE = new Functions();
    private Function[] funcs = new Function[8];

    static Functions get() {
        return INSTANCE;
    }

    private Functions() {
        for (Function sig : Function.VALUES) {
            String desc = sig.desc;
            byte[] ln = Token.token(desc.substring(0, desc.indexOf(40)));
            int i = this.put(new QNm(ln, sig.uri()).id());
            if (this.funcs[i] != null) {
                throw Util.notExpected("Function defined twice: " + (Object)((Object)sig), new Object[0]);
            }
            this.funcs[i] = sig;
        }
    }

    private static Type getCast(QNm name, long arity, InputInfo info) throws QueryException {
        byte[] ln = name.local();
        Enum type = ListType.find(name);
        if (type == null) {
            type = AtomType.find(name, false);
        }
        if (type != null && type != AtomType.NOT && type != AtomType.AAT) {
            if (arity == 1L) {
                return type;
            }
            throw QueryError.FUNCTYPES_X_X_X.get(info, name.string(), QueryError.arguments(arity), 1);
        }
        Levenshtein ls = new Levenshtein();
        for (AtomType tp : AtomType.VALUES) {
            byte[] u;
            if (tp.parent == null || !Token.eq(u = tp.name.uri(), QueryText.XS_URI) || tp == AtomType.NOT || tp == AtomType.AAT || !ls.similar(Token.lc(ln), Token.lc(tp.string()))) continue;
            throw QueryError.FUNCSIMILAR_X_X.get(info, name.prefixId(), tp.toString());
        }
        throw QueryError.WHICHFUNC_X.get(info, new Object[]{name.prefixId()});
    }

    Function getBuiltIn(QNm name) {
        int id = this.id(name.id());
        if (id == 0) {
            return null;
        }
        Function fn = this.funcs[id];
        return Token.eq(fn.uri(), name.uri()) ? fn : null;
    }

    private Function getBuiltIn(QNm name, long arity, InputInfo info) throws QueryException {
        Function fn = this.getBuiltIn(name);
        if (fn == null) {
            return null;
        }
        int min = fn.minMax[0];
        int max = fn.minMax[1];
        if (arity >= (long)min && arity <= (long)max) {
            return fn;
        }
        IntList arities = new IntList();
        if (max != Integer.MAX_VALUE) {
            for (int m = min; m <= max; ++m) {
                arities.add(m);
            }
        }
        throw Functions.wrongArity((Object)fn, arity, arities, info);
    }

    public static QueryException wrongArity(Object func, long arity, IntList arities, InputInfo info) {
        int as = arities.sort().size();
        if (as == 0) {
            return QueryError.FUNCARGNUM_X_X.get(info, func, QueryError.arguments(arity));
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int a = 0; a < as; ++a) {
            int m = arities.get(a);
            if (m < min) {
                min = m;
            }
            if (m <= max) continue;
            max = m;
        }
        StringBuilder ext = new StringBuilder();
        if (as > 2 && max - min + 1 == as) {
            ext.append(min).append('-').append(max);
        } else {
            for (int a = 0; a < as; ++a) {
                if (a != 0) {
                    ext.append(a + 1 < as ? ", " : " or ");
                }
                ext.append(arities.get(a));
            }
        }
        return QueryError.FUNCTYPES_X_X_X.get(info, func, QueryError.arguments(arity), ext);
    }

    StandardFunc get(QNm name, Expr[] args, StaticContext sc, InputInfo info) throws QueryException {
        Function fn = this.getBuiltIn(name, args.length, info);
        return fn == null ? null : fn.get(sc, info, args);
    }

    private static Expr closureOrFItem(AnnList anns, QNm name, Var[] params, FuncType ft, Expr expr, VarScope vs, InputInfo info, boolean runtime, boolean updating) {
        return runtime ? new FuncItem(vs.sc, anns, name, params, ft, expr, vs.stackSize()) : new Closure(info, name, updating ? SeqType.EMP : ft.declType, params, expr, anns, null, vs);
    }

    public static Expr getLiteral(QNm name, int arity, QueryContext qc, StaticContext sc, InputInfo info, boolean runtime) throws QueryException {
        if (Token.eq(name.uri(), QueryText.XS_URI)) {
            Type type = Functions.getCast(name, arity, info);
            VarScope vs = new VarScope(sc);
            Var[] params = new Var[]{vs.addNew(new QNm("item", ""), SeqType.AAT_ZO, true, qc, info)};
            Cast expr = new Cast(sc, info, new VarRef(info, params[0]), type.seqType());
            AnnList anns = new AnnList();
            FuncType ft = FuncType.get(anns, ((Expr)expr).seqType(), params);
            return Functions.closureOrFItem(anns, name, params, ft, expr, vs, info, runtime, false);
        }
        Function fn = Functions.get().getBuiltIn(name, arity, info);
        if (fn != null) {
            AnnList anns = new AnnList();
            VarScope vs = new VarScope(sc);
            FuncType ft = fn.type(arity, anns);
            QNm[] names = fn.paramNames(arity);
            Var[] params = new Var[arity];
            Expr[] args = new Expr[arity];
            for (int i = 0; i < arity; ++i) {
                params[i] = vs.addNew(names[i], ft.argTypes[i], true, qc, info);
                args[i] = new VarRef(info, params[i]);
            }
            StandardFunc sf = fn.get(sc, info, args);
            boolean upd = sf.has(Flag.UPD);
            if (upd) {
                anns.add(new Ann(info, Annotation.UPDATING, new Item[0]));
                qc.updating();
            }
            return sf.has(Flag.CTX, Flag.POS) ? new FuncLit(anns, name, params, sf, ft.seqType(), vs, info) : Functions.closureOrFItem(anns, name, params, fn.type(arity, anns), sf, vs, info, runtime, upd);
        }
        StaticFunc sf = qc.funcs.get(name, arity);
        if (sf != null) {
            FuncType ft = sf.funcType();
            VarScope vs = new VarScope(sc);
            Var[] params = new Var[arity];
            Expr[] args = new Expr[arity];
            for (int a = 0; a < arity; ++a) {
                params[a] = vs.addNew(sf.paramName(a), ft.argTypes[a], true, qc, info);
                args[a] = new VarRef(info, params[a]);
            }
            boolean upd = sf.updating;
            TypedFunc tf = qc.funcs.undeclaredFuncCall(sf.name, args, sc, info);
            Expr func = Functions.closureOrFItem(tf.anns, sf.name, params, ft, tf.func, vs, info, runtime, upd);
            if (upd) {
                qc.updating();
            }
            return func;
        }
        Object[] sts = new SeqType[arity];
        Arrays.fill(sts, SeqType.ITEM_ZM);
        AnnList anns = new AnnList();
        SeqType st = FuncType.get(anns, SeqType.ITEM_ZM, (SeqType[])sts).seqType();
        VarScope vs = new VarScope(sc);
        Var[] params = new Var[arity];
        Expr[] args = new Expr[arity];
        int vl = params.length;
        for (int v = 0; v < vl; ++v) {
            params[v] = vs.addNew(new QNm("arg" + (v + 1), ""), null, true, qc, info);
            args[v] = new VarRef(info, params[v]);
        }
        JavaFunction jf = JavaFunction.get(name, args, qc, sc, info);
        return jf == null ? null : new FuncLit(anns, name, params, jf, st, vs, info);
    }

    public static FuncItem getUser(StaticFunc sf, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        FuncType ft = sf.funcType();
        VarScope vs = new VarScope(sc);
        int arity = sf.params.length;
        Var[] args = new Var[arity];
        int al = args.length;
        Expr[] calls = new Expr[al];
        for (int a = 0; a < al; ++a) {
            args[a] = vs.addNew(sf.paramName(a), ft.argTypes[a], true, qc, info);
            calls[a] = new VarRef(info, args[a]);
        }
        TypedFunc tf = qc.funcs.undeclaredFuncCall(sf.name, calls, sc, info);
        return new FuncItem(sc, tf.anns, sf.name, args, ft, tf.func, vs.stackSize());
    }

    public static TypedFunc get(QNm name, Expr[] args, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        if (Token.eq(name.uri(), QueryText.XS_URI)) {
            Type type = Functions.getCast(name, args.length, info);
            SeqType to = SeqType.get(type, Occ.ZERO_ONE);
            return TypedFunc.constr(new Cast(sc, info, args[0], to));
        }
        StandardFunc sf = Functions.get().get(name, args, sc, info);
        if (sf != null) {
            AnnList anns = new AnnList();
            if (sf.sig.has(Flag.UPD)) {
                anns.add(new Ann(info, Annotation.UPDATING, new Item[0]));
                qc.updating();
            }
            return new TypedFunc(sf, anns);
        }
        TypedFunc tf = qc.funcs.funcCall(name, args, sc, info);
        if (tf != null) {
            if (tf.anns.contains(Annotation.UPDATING)) {
                qc.updating();
            }
            return tf;
        }
        JavaFunction jf = JavaFunction.get(name, args, qc, sc, info);
        if (jf != null) {
            return TypedFunc.java(jf);
        }
        if (FuncType.find(name) == null) {
            return qc.funcs.undeclaredFuncCall(name, args, sc, info);
        }
        return null;
    }

    QueryException similarError(QNm name, InputInfo info) {
        byte[] local = name.local();
        byte[] uri = name.uri();
        Levenshtein ls = new Levenshtein();
        for (int mode = 0; mode < 3; ++mode) {
            for (byte[] key : this) {
                int i = Token.indexOf(key, 125);
                byte[] slocal = Token.substring(key, i + 1);
                byte[] suri = Token.substring(key, 2, i);
                if (!(mode == 0 ? Token.eq(uri, suri) && ls.similar(local, slocal) : (mode == 1 ? Token.eq(local, Token.substring(key, i + 1)) : Token.eq(uri, Token.substring(key, 2, i)) && Token.startsWith(Token.substring(key, i + 1), local)))) continue;
                QNm sim = new QNm(slocal, suri);
                return QueryError.FUNCSIMILAR_X_X.get(info, name.prefixId(), sim.prefixId());
            }
        }
        return null;
    }

    @Override
    protected void rehash(int s) {
        super.rehash(s);
        this.funcs = Array.copy(this.funcs, new Function[s]);
    }
}

