/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.collation;

import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.collation.Collation;
import org.basex.util.InputInfo;
import org.basex.util.Token;

final class BaseXCollation
extends Collation {
    private final Comparator<Object> collator;

    BaseXCollation(Comparator<Object> collator) {
        this.collator = collator;
    }

    @Override
    public int compare(byte[] string, byte[] compare) {
        return this.collator.compare(Token.string(string), Token.string(compare));
    }

    @Override
    protected int indexOf(String string, String contains, Collation.Mode mode, InputInfo info) throws QueryException {
        if (!(this.collator instanceof RuleBasedCollator)) {
            throw QueryError.CHARCOLL.get(info, new Object[0]);
        }
        RuleBasedCollator rbc = (RuleBasedCollator)this.collator;
        CollationElementIterator iterS = rbc.getCollationElementIterator(string);
        CollationElementIterator iterC = rbc.getCollationElementIterator(contains);
        int elemC = BaseXCollation.next(iterC);
        if (elemC == -1) {
            return 0;
        }
        int offC = iterC.getOffset();
        while (true) {
            int elemS;
            if ((elemS = BaseXCollation.next(iterS)) != elemC) {
                if (elemS != -1 && mode != Collation.Mode.STARTS_WITH) continue;
                return -1;
            }
            int offS = iterS.getOffset();
            if (BaseXCollation.startsWith(iterS, iterC)) {
                if (mode == Collation.Mode.INDEX_AFTER) {
                    return iterS.getOffset();
                }
                if (mode == Collation.Mode.ENDS_WITH) {
                    if (BaseXCollation.next(iterS) == -1) {
                        return offS - 1;
                    }
                } else {
                    return offS - 1;
                }
            }
            iterS.setOffset(offS);
            iterC.setOffset(offC);
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof BaseXCollation && this.collator.equals(((BaseXCollation)obj).collator);
    }

    private static boolean startsWith(CollationElementIterator string, CollationElementIterator sub) {
        int s;
        while ((s = BaseXCollation.next(sub)) != -1) {
            if (s == BaseXCollation.next(string)) continue;
            return false;
        }
        return true;
    }

    private static int next(CollationElementIterator it) {
        int c;
        while ((c = it.next()) == 0) {
        }
        return c;
    }
}

