/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.value.array.Array;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class ArrayType
extends FuncType {
    ArrayType(SeqType declType) {
        super(declType, SeqType.ITR_O);
    }

    @Override
    public byte[] string() {
        return Token.token("array");
    }

    @Override
    public Array cast(Item item, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        Array a;
        if (item instanceof Array && (a = (Array)item).instanceOf(this)) {
            return a;
        }
        throw QueryError.typeError(item, this, info);
    }

    @Override
    public boolean eq(Type type) {
        return this == type || type instanceof ArrayType && this.declType.eq(((ArrayType)type).declType);
    }

    @Override
    public boolean instanceOf(Type type) {
        if (type == AtomType.ITEM || type == SeqType.ANY_ARRAY || type == SeqType.ANY_FUNC) {
            return true;
        }
        if (!(type instanceof FuncType) || type instanceof MapType || this == SeqType.ANY_ARRAY) {
            return false;
        }
        FuncType ft = (FuncType)type;
        int al = this.argTypes.length;
        if (al != ft.argTypes.length || !this.declType.instanceOf(ft.declType)) {
            return false;
        }
        if (type instanceof ArrayType) {
            return true;
        }
        for (int a = 0; a < al; ++a) {
            if (this.argTypes[a].instanceOf(ft.argTypes[a])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type union(Type type) {
        if (this.instanceOf(type)) {
            return type;
        }
        if (type instanceof ArrayType) {
            ArrayType mt = (ArrayType)type;
            return mt.instanceOf(this) ? this : ArrayType.get(this.declType.union(mt.declType));
        }
        return type instanceof MapType ? SeqType.ANY_FUNC : (type instanceof FuncType ? type.union(this) : AtomType.ITEM);
    }

    @Override
    public ArrayType intersect(Type type) {
        if (this.instanceOf(type)) {
            return this;
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            if (at.instanceOf(this)) {
                return at;
            }
            SeqType dt = this.declType.intersect(at.declType);
            return dt == null ? null : ArrayType.get(dt);
        }
        if (type instanceof FuncType) {
            FuncType ft = (FuncType)type;
            if (ft.argTypes.length == 1 && ft.argTypes[0].instanceOf(SeqType.ITR_O)) {
                SeqType dt = this.declType.intersect(ft.declType);
                return dt == null ? null : ArrayType.get(dt);
            }
        }
        return null;
    }

    public static ArrayType get(SeqType declType) {
        return declType.eq(SeqType.ITEM_ZM) ? SeqType.ANY_ARRAY : new ArrayType(declType);
    }

    @Override
    public String toString() {
        return this.declType.eq(SeqType.ITEM_ZM) ? "array(*)" : "array(" + this.declType + ')';
    }
}

