/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.basex.io.IOFile;
import org.basex.util.JarManifest;
import org.basex.util.Util;
import org.basex.util.options.Option;

public final class Prop {
    public static final String NAME = "BaseX";
    public static final String VERSION;
    public static final String AUTHOR = "Christian Gr\u00fcn";
    public static final String TEAM1 = "Michael Seiferle, Alexander Holupirek";
    public static final String TEAM2 = "Marc H. Scholl, Sabine Teubner";
    public static final String ENTITY = "BaseX Team";
    public static final String PROJECT_NAME;
    public static final String URL;
    public static final String COMMUNITY_URL;
    public static final String DOC_URL;
    public static final String UPDATE_URL;
    public static final String VERSION_URL;
    public static final String REPO_URL;
    public static final String MAILING_LIST;
    public static final String TITLE;
    public static final String NL;
    public static final String ENCODING;
    private static final String OS;
    public static final boolean MAC;
    public static final boolean WIN;
    public static final boolean CASE;
    public static final String JAVA;
    public static final String DBPREFIX = "org.basex.";
    public static final String PATH = "org.basex.path";
    public static final String TEMPDIR;
    public static final String HOMEDIR;
    public static final URL LOCATION;
    private static final Map<String, String> OPTIONS;
    public static String language;
    public static boolean langkeys;
    public static boolean langright;
    public static boolean debug;
    public static boolean gui;

    private Prop() {
    }

    private static String configDir(String dir) {
        if (dir != null) {
            String home = ".basexhome";
            IOFile file = new IOFile(dir, ".basexhome");
            if (file.exists() || new IOFile(dir, ".basex").exists()) {
                return dir;
            }
        }
        return null;
    }

    private static String applicationDir(URL location) {
        try {
            if (location != null) {
                return new IOFile(Paths.get(location.toURI()).toString()).dir();
            }
        }
        catch (Exception ex) {
            Util.stack(ex);
        }
        return null;
    }

    private static String dir(String path) {
        return path.isEmpty() || path.endsWith("\\") || path.endsWith("/") ? path : path + File.separator;
    }

    private static String version(String devVersion) {
        String version = Prop.class.getPackage().getImplementationVersion();
        if (version == null) {
            return devVersion;
        }
        if (!version.contains("-SNAPSHOT")) {
            return version;
        }
        StringBuilder result = new StringBuilder(version.replace("-SNAPSHOT", " beta"));
        Object revision = JarManifest.get("Implementation-Build");
        if (revision != null) {
            result.append(' ').append(revision);
        }
        return result.toString();
    }

    public static void put(Option<?> option, String value) {
        Prop.put(Prop.key(option), value);
    }

    public static void put(String name, String value) {
        OPTIONS.put(name, value);
    }

    public static void clear() {
        OPTIONS.clear();
    }

    public static String get(String name) {
        String value = System.getProperty(name);
        return value != null ? value : OPTIONS.get(name);
    }

    public static String get(Option<?> option) {
        return Prop.get(Prop.key(option));
    }

    public static Set<Map.Entry<String, String>> entries() {
        HashMap<String, String> entries = new HashMap<String, String>(OPTIONS);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> entries.put(key.toString(), value.toString())));
        return entries.entrySet();
    }

    public static void setSystem(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    private static String key(Option<?> option) {
        return DBPREFIX + option.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        CodeSource cs;
        VERSION = Prop.version("9.0.1");
        PROJECT_NAME = NAME.toLowerCase(Locale.ENGLISH);
        URL = "http://" + PROJECT_NAME + ".org";
        COMMUNITY_URL = URL + "/community";
        DOC_URL = "http://docs." + PROJECT_NAME + ".org";
        UPDATE_URL = URL + "/products/download/all-downloads/";
        VERSION_URL = "http://files." + PROJECT_NAME + ".org/version.txt";
        REPO_URL = "http://files." + PROJECT_NAME + ".org/modules";
        MAILING_LIST = PROJECT_NAME + "-talk@mailman.uni-konstanz.de";
        TITLE = "BaseX " + VERSION;
        NL = System.getProperty("line.separator");
        ENCODING = System.getProperty("file.encoding");
        OS = System.getProperty("os.name");
        MAC = OS.startsWith("Mac");
        WIN = OS.startsWith("Windows");
        CASE = !MAC && !WIN;
        JAVA = System.getProperty("java.specification.version");
        TEMPDIR = Prop.dir(System.getProperty("java.io.tmpdir"));
        OPTIONS = new ConcurrentHashMap<String, String>();
        URL location = null;
        ProtectionDomain pd = Prop.class.getProtectionDomain();
        if (pd != null && (cs = pd.getCodeSource()) != null) {
            location = cs.getLocation();
        }
        LOCATION = location;
        String homedir = System.getProperty(PATH);
        if (homedir == null) {
            homedir = Prop.configDir(System.getProperty("user.dir"));
        }
        if (homedir == null) {
            homedir = Prop.configDir(Prop.applicationDir(location));
        }
        if (homedir == null) {
            String home = WIN ? null : System.getenv("HOME");
            homedir = Prop.dir(home != null ? home : System.getProperty("user.home")) + PROJECT_NAME;
        }
        HOMEDIR = Prop.dir(homedir);
        language = "English";
    }
}

