/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Token;
import org.basex.util.list.ElementList;

public class ByteList
extends ElementList {
    protected byte[] list;

    public ByteList() {
        this(8);
    }

    public ByteList(int capacity) {
        this.list = new byte[capacity];
    }

    public ByteList add(int element) {
        int s = this.size;
        byte[] lst = this.list;
        if (s == lst.length) {
            lst = Arrays.copyOf(lst, this.newSize());
        }
        lst[s] = (byte)element;
        this.list = lst;
        this.size = s + 1;
        return this;
    }

    public ByteList add(byte[] elements) {
        return this.add(elements, 0, elements.length);
    }

    public ByteList add(byte[] elements, int start, int end) {
        int l = end - start;
        if (this.size + l > this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize(this.size + l));
        }
        System.arraycopy(elements, start, this.list, this.size, l);
        this.size += l;
        return this;
    }

    public final byte get(int index) {
        return this.list[index];
    }

    public byte[] toArray() {
        int s = this.size;
        return s == 0 ? Token.EMPTY : Arrays.copyOf(this.list, s);
    }

    public final byte[] next() {
        int s = this.size;
        if (s == 0) {
            return Token.EMPTY;
        }
        this.size = 0;
        return Arrays.copyOf(this.list, s);
    }

    public byte[] finish() {
        byte[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == 0 ? Token.EMPTY : (s == lst.length ? lst : Arrays.copyOf(lst, s));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteList)) {
            return false;
        }
        ByteList bl = (ByteList)obj;
        if (this.size != bl.size) {
            return false;
        }
        for (int l = 0; l < this.size; ++l) {
            if (this.list[l] == bl.list[l]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Token.string(this.list, 0, this.size);
    }
}

