/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.DateUtils;
import com.bradmcevoy.http.Response;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResponse
implements Response {
    private static final Logger log = LoggerFactory.getLogger(AbstractResponse.class);
    protected Long contentLength;
    protected Response.Entity entity;

    public void setResponseHeader(Response.Header header, String value) {
        this.setNonStandardHeader(header.code, value);
    }

    public String getResponseHeader(Response.Header header) {
        return this.getNonStandardHeader(header.code);
    }

    @Override
    public void setContentEncodingHeader(Response.ContentEncoding encoding) {
        this.setResponseHeader(Response.Header.CONTENT_ENCODING, encoding.code);
    }

    @Override
    public Long getContentLength() {
        return this.contentLength;
    }

    @Override
    public void setDateHeader(Date date) {
        this.setAnyDateHeader(Response.Header.DATE, date);
    }

    @Override
    public void setContentRangeHeader(long start, long finish, Long totalLength) {
        String l = totalLength == null ? "*" : totalLength.toString();
        String s = null;
        if (finish > -1L) {
            s = "bytes " + start + "-" + finish + "/" + l;
        } else {
            long wrotetill = totalLength - 1L;
            s = "bytes " + start + "-" + wrotetill + "/" + l;
        }
        this.setResponseHeader(Response.Header.CONTENT_RANGE, s);
    }

    @Override
    public void setContentLengthHeader(Long totalLength) {
        String s = totalLength == null ? "" : totalLength.toString();
        this.setResponseHeader(Response.Header.CONTENT_LENGTH, s);
        this.contentLength = totalLength;
    }

    @Override
    public void setContentTypeHeader(String type) {
        this.setResponseHeader(Response.Header.CONTENT_TYPE, type);
    }

    @Override
    public String getContentTypeHeader() {
        return this.getResponseHeader(Response.Header.CONTENT_TYPE);
    }

    @Override
    public void setCacheControlMaxAgeHeader(Long delta) {
        if (delta != null) {
            this.setResponseHeader(Response.Header.CACHE_CONTROL, Response.CacheControlResponse.MAX_AGE.code + "=" + delta);
        } else {
            this.setResponseHeader(Response.Header.CACHE_CONTROL, Response.CacheControlResponse.NO_CACHE.code);
        }
    }

    @Override
    public void setCacheControlPrivateMaxAgeHeader(Long delta) {
        if (delta != null) {
            this.setResponseHeader(Response.Header.CACHE_CONTROL, Response.CacheControlResponse.PRIVATE.code + " " + Response.CacheControlResponse.MAX_AGE.code + "=" + delta);
        } else {
            this.setResponseHeader(Response.Header.CACHE_CONTROL, Response.CacheControlResponse.PRIVATE.code);
        }
    }

    @Override
    public void setExpiresHeader(Date expiresAt) {
        if (expiresAt == null) {
            this.setResponseHeader(Response.Header.EXPIRES, null);
        } else {
            this.setAnyDateHeader(Response.Header.EXPIRES, expiresAt);
        }
    }

    @Override
    public void setEtag(String uniqueId) {
        this.setResponseHeader(Response.Header.ETAG, uniqueId);
    }

    @Override
    public void setLastModifiedHeader(Date date) {
        this.setAnyDateHeader(Response.Header.LAST_MODIFIED, date);
    }

    @Override
    public void setCacheControlNoCacheHeader() {
        this.setResponseHeader(Response.Header.CACHE_CONTROL, Response.CacheControlResponse.NO_CACHE.code);
    }

    @Override
    public void setLocationHeader(String redirectUrl) {
        this.setResponseHeader(Response.Header.LOCATION, redirectUrl);
    }

    @Override
    public void setAllowHeader(List<String> methodsAllowed) {
        if (methodsAllowed == null || methodsAllowed.isEmpty()) {
            return;
        }
        StringBuilder sb = null;
        for (String m : methodsAllowed) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(",");
            }
            sb.append(m);
        }
        this.setResponseHeader(Response.Header.ALLOW, sb.toString());
    }

    @Override
    public void setLockTokenHeader(String s) {
        this.setResponseHeader(Response.Header.LOCK_TOKEN, s);
    }

    @Override
    public void setDavHeader(String supportedLevels) {
        this.setResponseHeader(Response.Header.DAV, supportedLevels);
    }

    @Override
    public void setVaryHeader(String value) {
        this.setResponseHeader(Response.Header.VARY, value);
    }

    @Override
    public void setEntity(Response.Entity entity) {
        this.entity = entity;
    }

    @Override
    public Response.Entity getEntity() {
        return this.entity;
    }

    @Override
    public void sendRedirect(String url) {
        if (log.isTraceEnabled()) {
            log.trace("sendRedirect: " + url);
        }
        this.setStatus(Response.Status.SC_MOVED_TEMPORARILY);
        this.setLocationHeader(url);
    }

    protected void setAnyDateHeader(Response.Header name, Date date) {
        if (date == null) {
            return;
        }
        String fmt = DateUtils.formatForHeader(date);
        this.setResponseHeader(name, fmt);
    }
}

