/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.cmd.Open;
import org.basex.http.BaseXServlet;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPConnection;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTDelete;
import org.basex.http.rest.RESTGet;
import org.basex.http.rest.RESTPost;
import org.basex.http.rest.RESTPut;
import org.basex.http.rest.RESTSession;
import org.basex.util.http.HttpMethod;

public final class RESTServlet
extends BaseXServlet {
    @Override
    protected void run(HTTPConnection conn) throws IOException {
        RESTCmd cmd;
        block4: {
            RESTSession session = new RESTSession(conn);
            String db = conn.db();
            String path = conn.dbpath();
            if (!db.isEmpty()) {
                session.add((Command)new Open(db, path));
            }
            cmd = RESTServlet.command(session);
            try {
                cmd.execute(conn.context);
            }
            catch (BaseXException ex) {
                if (cmd.code != null) break block4;
                throw ex;
            }
        }
        HTTPCode code = cmd.code;
        if (code != null) {
            throw code.get(cmd.info());
        }
    }

    private static RESTCmd command(RESTSession session) throws IOException {
        String mth = session.conn.method;
        if (mth.equals(HttpMethod.GET.name())) {
            return RESTGet.get(session);
        }
        if (mth.equals(HttpMethod.POST.name())) {
            return RESTPost.get(session);
        }
        if (mth.equals(HttpMethod.PUT.name())) {
            return RESTPut.get(session);
        }
        if (mth.equals(HttpMethod.DELETE.name())) {
            return RESTDelete.get(session);
        }
        throw HTTPCode.NOT_IMPLEMENTED_X.get(session.conn.req.getMethod());
    }
}

