/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import javax.servlet.http.HttpSession;
import org.basex.http.HTTPConnection;
import org.basex.query.QueryContext;
import org.basex.util.Performance;

final class RestXqSingleton {
    private static final Object MUTEX = new Object();
    private final String singleton;
    private final QueryContext qc;
    private final HttpSession session;

    RestXqSingleton(HTTPConnection conn, String singleton, QueryContext qc) {
        this.qc = qc;
        this.singleton = singleton;
        this.session = conn.req.getSession();
        this.queue();
        this.register();
    }

    void queue() {
        QueryContext oldQc = this.qc();
        if (oldQc != null) {
            oldQc.stop();
            do {
                Performance.sleep((long)1L);
            } while (this.qc() == oldQc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register() {
        Object object = MUTEX;
        synchronized (object) {
            this.session.setAttribute(this.singleton, (Object)this.qc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister() {
        Object object = MUTEX;
        synchronized (object) {
            if (this.qc == this.qc()) {
                this.session.removeAttribute(this.singleton);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryContext qc() {
        Object object = MUTEX;
        synchronized (object) {
            Object obj = this.session.getAttribute(this.singleton);
            return obj instanceof QueryContext ? (QueryContext)obj : null;
        }
    }
}

