/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.basex.http.webdav.WebDAVCode;
import org.basex.http.webdav.WebDAVDatabase;
import org.basex.http.webdav.WebDAVFolder;
import org.basex.http.webdav.WebDAVMetaData;
import org.basex.http.webdav.WebDAVResource;
import org.basex.http.webdav.WebDAVService;
import org.basex.http.webdav.WebDAVUtils;

final class WebDAVRoot
extends WebDAVFolder {
    WebDAVRoot(WebDAVService service) {
        super(new WebDAVMetaData(), service);
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void copyTo(CollectionResource toCollection, String name) {
    }

    @Override
    public void delete() {
    }

    @Override
    public void moveTo(CollectionResource rDest, String name) {
    }

    @Override
    public WebDAVResource child(final String name) {
        return (WebDAVResource)new WebDAVCode<WebDAVResource>((WebDAVResource)this){

            @Override
            public WebDAVResource get() throws IOException {
                return WebDAVRoot.this.service.dbExists(name) ? new WebDAVDatabase(new WebDAVMetaData(name, WebDAVRoot.this.service.timestamp(name)), WebDAVRoot.this.service) : null;
            }
        }.evalNoEx();
    }

    @Override
    public List<WebDAVResource> getChildren() {
        return (List)new WebDAVCode<List<WebDAVResource>>((WebDAVResource)this){

            @Override
            public List<WebDAVResource> get() throws IOException {
                return WebDAVRoot.this.service.listDbs();
            }
        }.evalNoEx();
    }

    @Override
    public WebDAVDatabase createCollection(final String name) throws BadRequestException, NotAuthorizedException {
        return (WebDAVDatabase)new WebDAVCode<WebDAVDatabase>((WebDAVResource)this){

            @Override
            public WebDAVDatabase get() throws IOException {
                return (WebDAVDatabase)WebDAVRoot.this.service.createDb(WebDAVUtils.dbName(name));
            }
        }.eval();
    }

    @Override
    public WebDAVResource createNew(final String name, final InputStream input, Long length, String contentType) throws BadRequestException, NotAuthorizedException {
        return (WebDAVResource)new WebDAVCode<WebDAVResource>((WebDAVResource)this){

            @Override
            public WebDAVResource get() throws IOException {
                return WebDAVRoot.this.service.createFile(name, input);
            }
        }.eval();
    }
}

