/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.basex.api.client.LocalSession;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.AlterDB;
import org.basex.core.cmd.Copy;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.DropDB;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Rename;
import org.basex.core.cmd.Set;
import org.basex.core.cmd.XQuery;
import org.basex.http.HTTPConnection;
import org.basex.http.webdav.WebDAVFactory;
import org.basex.http.webdav.WebDAVLockService;
import org.basex.http.webdav.WebDAVMetaData;
import org.basex.http.webdav.WebDAVQuery;
import org.basex.http.webdav.WebDAVResource;
import org.basex.http.webdav.WebDAVUtils;
import org.basex.io.in.ArrayInput;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.func.Function;
import org.basex.query.func.db.DbFn;
import org.basex.util.DateTime;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.http.MediaType;
import org.basex.util.list.StringList;
import org.basex.util.options.Option;

final class WebDAVService {
    private static final String WEBDAV_DB = "~webdav";
    private static final String WEBDAV;
    final HTTPConnection conn;
    final WebDAVLockService locking;
    private LocalSession ls;

    WebDAVService(HTTPConnection conn) {
        this.conn = conn;
        this.locking = new WebDAVLockService(conn);
    }

    void close() {
        if (this.ls != null) {
            this.ls.close();
        }
    }

    static boolean authorize(String db) {
        return !WEBDAV_DB.equals(db);
    }

    void deleteDummy(String db, String path) throws IOException {
        String dummy = path + '/' + ".empty";
        if (!this.pathExists(db, dummy)) {
            return;
        }
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        session.execute((Command)new Delete(dummy));
    }

    boolean dbExists(String db) throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function._DB_EXISTS.args(new Object[]{" $db"})).bind("db", db);
        return this.execute(query).equals("true");
    }

    long timestamp(String db) throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function.DATA.args(new Object[]{Function._DB_INFO.args(new Object[]{" $db"}) + "/descendant::" + DbFn.toName((String)Text.TIMESTAMP) + "[1]"})).bind("db", db);
        return DateTime.parse((String)this.execute(query)).getTime();
    }

    private WebDAVMetaData metaData(String db, String path) throws IOException {
        WebDAVQuery query = new WebDAVQuery("let $a := " + Function._DB_LIST_DETAILS.args(new Object[]{" $db", " $path"}) + "[1] return string-join(($a/@raw, $a/@content-type, $a/@modified-date, $a/@size, $a),out:tab())");
        query.bind("db", db);
        query.bind("path", path);
        String[] result = this.results(query);
        boolean raw = Boolean.parseBoolean(result[0]);
        MediaType type = new MediaType(result[1]);
        long mod = DateTime.parse((String)result[2]).getTime();
        Long size = raw ? Long.valueOf(result[3]) : null;
        String pth = WebDAVUtils.stripLeadingSlash(result[4]);
        return new WebDAVMetaData(db, pth, mod, raw, type, size);
    }

    void delete(String db, String path) throws IOException {
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        session.execute((Command)new Delete(path));
        int ix = path.lastIndexOf(47);
        if (ix > 0) {
            this.createDummy(db, path.substring(0, ix));
        }
    }

    void rename(String db, String path, String npath) throws IOException {
        int i2;
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        session.execute((Command)new Rename(path, npath));
        int i1 = path.lastIndexOf(47);
        if (i1 > 0) {
            this.createDummy(db, path.substring(0, i1));
        }
        if ((i2 = npath.lastIndexOf(47)) > 0) {
            this.deleteDummy(db, npath.substring(0, i2));
        }
    }

    void copyDoc(String db, String path, String tdb, String tpath) throws IOException {
        WebDAVQuery query = new WebDAVQuery("declare option db:chop 'false';if(" + Function._DB_IS_RAW.args(new Object[]{" $db", " $path"}) + ')' + " then " + Function._DB_STORE.args(new Object[]{" $tdb", " $tpath", Function._DB_RETRIEVE.args(new Object[]{" $db", " $path"})}) + " else " + Function._DB_ADD.args(new Object[]{" $tdb", Function._DB_OPEN.args(new Object[]{" $db", " $path"}), " $tpath"}));
        query.bind("db", db);
        query.bind("path", path);
        query.bind("tdb", tdb);
        query.bind("tpath", tpath);
        this.execute(query);
    }

    void copyAll(String db, String path, String tdb, String tpath) throws IOException {
        WebDAVQuery query = new WebDAVQuery("declare option db:chop 'false'; for $d in " + Function._DB_LIST.args(new Object[]{" $db", " $path"}) + "let $t := $tpath ||'/'|| substring($d, string-length($path) + 1) return if(" + Function._DB_IS_RAW.args(new Object[]{" $db", " $d"}) + ") then " + Function._DB_STORE.args(new Object[]{" $tdb", " $t", Function._DB_RETRIEVE.args(new Object[]{" $db", " $d"})}) + " else " + Function._DB_ADD.args(new Object[]{" $tdb", Function._DB_OPEN.args(new Object[]{" $db", " $d"}), " $t"}));
        query.bind("db", db);
        query.bind("path", path);
        query.bind("tdb", tdb);
        query.bind("tpath", tpath);
        this.execute(query);
    }

    void retrieve(String db, String path, boolean raw, OutputStream out) throws IOException {
        this.session().setOutputStream(out);
        String string = SerializerOptions.USE_CHARACTER_MAPS.arg(WEBDAV) + (raw ? Function._DB_RETRIEVE : Function._DB_OPEN).args(new Object[]{" $db", " $path"}) + "[1]";
        WebDAVQuery query = new WebDAVQuery(string);
        query.bind("db", db);
        query.bind("path", path);
        this.execute(query);
    }

    WebDAVResource createDb(String db) throws IOException {
        this.session().execute((Command)new CreateDB(db));
        return WebDAVFactory.database(this, new WebDAVMetaData(db, this.timestamp(db)));
    }

    void dropDb(String db) throws IOException {
        this.session().execute((Command)new DropDB(db));
    }

    void renameDb(String old, String db) throws IOException {
        this.session().execute((Command)new AlterDB(old, WebDAVUtils.dbName(db)));
    }

    void copyDb(String old, String db) throws IOException {
        this.session().execute((Command)new Copy(old, WebDAVUtils.dbName(db)));
    }

    List<WebDAVResource> list(String db, String path) throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function.STRING_JOIN.args(new Object[]{Function._DB_LIST_DETAILS.args(new Object[]{" $db", " $path"}) + " ! (@raw,@content-type,@modified-date,@size," + Function.SUBSTRING_AFTER.args(new Object[]{" text()", " $path"}) + ')', Function._OUT_TAB.args(new Object[0])}));
        query.bind("db", db);
        query.bind("path", path);
        String[] result = this.results(query);
        HashSet<String> paths = new HashSet<String>();
        ArrayList<WebDAVResource> ch = new ArrayList<WebDAVResource>();
        int rs = result.length;
        for (int r = 0; r < rs; r += 5) {
            boolean raw = Boolean.parseBoolean(result[r]);
            MediaType ctype = new MediaType(result[r + 1]);
            long mod = DateTime.parse((String)result[r + 2]).getTime();
            Long size = raw ? Long.valueOf(result[r + 3]) : null;
            String pth = WebDAVUtils.stripLeadingSlash(result[r + 4]);
            int ix = pth.indexOf(47);
            if (ix < 0) {
                if (pth.equals(".empty")) continue;
                ch.add(WebDAVFactory.file(this, new WebDAVMetaData(db, path + '/' + pth, mod, raw, ctype, size)));
                continue;
            }
            String dir = path + '/' + pth.substring(0, ix);
            if (!paths.add(dir)) continue;
            ch.add(WebDAVFactory.folder(this, new WebDAVMetaData(db, dir, mod)));
        }
        return ch;
    }

    List<WebDAVResource> listDbs() throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function.STRING_JOIN.args(new Object[]{Function._DB_LIST_DETAILS.args(new Object[0]) + "[. != $db] ! (text(), @modified-date)", Function._OUT_TAB.args(new Object[0])}));
        query.bind("db", WEBDAV_DB);
        String[] result = this.results(query);
        ArrayList<WebDAVResource> dbs = new ArrayList<WebDAVResource>();
        int rs = result.length;
        for (int r = 0; r < rs; r += 2) {
            String name = result[r];
            long mod = DateTime.parse((String)result[r + 1]).getTime();
            dbs.add(WebDAVFactory.database(this, new WebDAVMetaData(name, mod)));
        }
        return dbs;
    }

    WebDAVResource createFolder(String db, String path, String name) throws IOException {
        this.deleteDummy(db, path);
        String newFolder = path + '/' + name;
        this.createDummy(db, newFolder);
        return WebDAVFactory.folder(this, new WebDAVMetaData(db, newFolder, this.timestamp(db)));
    }

    WebDAVResource resource(String db, String path) throws IOException {
        return this.exists(db, path) ? WebDAVFactory.file(this, this.metaData(db, path)) : (this.pathExists(db, path) ? WebDAVFactory.folder(this, new WebDAVMetaData(db, path, this.timestamp(db))) : null);
    }

    WebDAVResource createFile(String db, String path, String name, InputStream in) throws IOException {
        String dbp;
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        String string = dbp = path.isEmpty() ? name : path + '/' + name;
        if (this.pathExists(db, dbp)) {
            session.execute((Command)new Open(db));
            session.execute((Command)new Delete(dbp));
        } else {
            this.deleteDummy(db, path);
        }
        return this.addFile(db, dbp, in);
    }

    WebDAVResource createFile(String n, InputStream in) throws IOException {
        return this.addFile(null, n, in);
    }

    private boolean pathExists(String db, String path) throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function.EXISTS.args(new Object[]{Function._DB_LIST.args(new Object[]{" $db", " $path"})}));
        query.bind("db", db);
        query.bind("path", path);
        return this.execute(query).equals("true");
    }

    private boolean exists(String db, String path) throws IOException {
        WebDAVQuery query = new WebDAVQuery(Function._DB_EXISTS.args(new Object[]{" $db", " $path"}));
        query.bind("db", db);
        query.bind("path", path);
        return this.execute(query).equals("true");
    }

    private WebDAVResource createDb(String db, InputStream in) throws IOException {
        this.session().create(db, in);
        return WebDAVFactory.database(this, new WebDAVMetaData(db, this.timestamp(db)));
    }

    private WebDAVResource addXML(String db, String path, InputStream in) throws IOException {
        LocalSession session = this.session();
        session.execute((Command)new Set((Option)MainOptions.CHOP, (Object)false));
        session.execute((Command)new Open(db));
        session.add(path, in);
        return WebDAVFactory.file(this, new WebDAVMetaData(db, path, this.timestamp(db), false, MediaType.APPLICATION_XML, null));
    }

    private WebDAVResource store(String db, String path, InputStream in) throws IOException {
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        session.store(path, in);
        return WebDAVFactory.file(this, this.metaData(db, path));
    }

    /*
     * Exception decompiling
     */
    private WebDAVResource addFile(String db, String path, InputStream in) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createDummy(String db, String path) throws IOException {
        if (path.matches("[^/]") || this.pathExists(db, path)) {
            return;
        }
        LocalSession session = this.session();
        session.execute((Command)new Open(db));
        session.store(path + '/' + ".empty", (InputStream)new ArrayInput(Token.EMPTY));
    }

    private String execute(WebDAVQuery query) throws IOException {
        XQuery xquery = new XQuery(query.toString());
        for (Map.Entry<String, String> entry : query.entries()) {
            xquery.bind(entry.getKey(), entry.getValue());
        }
        return this.session().execute((Command)xquery);
    }

    private String[] results(WebDAVQuery query) throws IOException {
        StringList sl = new StringList();
        for (String result : Strings.split((String)this.execute(query), (char)'\t')) {
            if (result.isEmpty()) continue;
            sl.add((Object)result);
        }
        return (String[])sl.finish();
    }

    private LocalSession session() {
        if (this.ls == null) {
            this.ls = new LocalSession(this.conn.context);
        }
        return this.ls;
    }

    private static void add(int ch, StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(',');
        }
        sb.append((char)ch).append("=&amp;#").append(ch).append(';');
    }

    static {
        int cp;
        StringBuilder sb = new StringBuilder();
        WebDAVService.add(160, sb);
        for (cp = 8192; cp <= 8207; ++cp) {
            WebDAVService.add(cp, sb);
        }
        for (cp = 8232; cp <= 8239; ++cp) {
            WebDAVService.add(cp, sb);
        }
        for (cp = 8287; cp <= 8303; ++cp) {
            WebDAVService.add(cp, sb);
        }
        WEBDAV = sb.toString();
    }
}

