/*
 * Decompiled with CFR 0.152.
 */
package org.expath.ns;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.io.gml2.GMLReader;
import com.vividsolutions.jts.io.gml2.GMLWriter;
import java.io.IOException;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.xml.XMLParser;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;
import org.basex.util.Util;
import org.expath.ns.GeoErrors;

public final class Geo
extends QueryModule {
    private static final byte[] URI = Token.token((String)"http://www.opengis.net/gml");
    private static final byte[] GML = Token.token((String)"gml");
    private static final QNm Q_GML_POINT = new QNm(GML, "Point", URI);
    private static final QNm Q_GML_MULTIPOINT = new QNm(GML, "MultiPoint", URI);
    private static final QNm Q_GML_LINESTRING = new QNm(GML, "LineString", URI);
    private static final QNm Q_GML_LINEARRING = new QNm(GML, "LinearRing", URI);
    private static final QNm Q_GML_POLYGON = new QNm(GML, "Polygon", URI);
    private static final QNm Q_GML_MULTIPOLYGON = new QNm(GML, "MultiPolygon", URI);
    private static final QNm Q_GML_MULTILINESTRING = new QNm(GML, "MultiLineString", URI);
    private static final QNm[] QNAMES = new QNm[]{Q_GML_POINT, Q_GML_LINESTRING, Q_GML_POLYGON, Q_GML_MULTIPOINT, Q_GML_MULTILINESTRING, Q_GML_MULTIPOLYGON, Q_GML_LINEARRING};

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Int dimension(ANode node) throws QueryException {
        return Int.get((long)Geo.checkGeo(node).getDimension());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public QNm geometryType(ANode node) throws QueryException {
        return new QNm(GML, Geo.checkGeo(node).getGeometryType(), URI);
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Uri srid(ANode node) throws QueryException {
        return Uri.uri((byte[])Token.token((int)Geo.checkGeo(node).getSRID()));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode envelope(ANode node) throws QueryException {
        return this.toElement(Geo.checkGeo(node).getEnvelope());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Str asText(ANode node) throws QueryException {
        return Str.get((String)new WKTWriter().write(Geo.checkGeo(node)));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public B64 asBinary(ANode node) throws QueryException {
        return B64.get((byte[])new WKBWriter().write(Geo.checkGeo(node)));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln isEmpty(ANode node) throws QueryException {
        if (node == null) {
            return Bln.FALSE;
        }
        Geo.checkGeo(node);
        return Bln.TRUE;
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln isSimple(ANode node) throws QueryException {
        return Bln.get((boolean)Geo.checkGeo(node).isSimple());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode boundary(ANode node) throws QueryException {
        return this.toElement(Geo.checkGeo(node).getBoundary());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln equals(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return Bln.get((boolean)geo1.equals(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln disjoint(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return Bln.get((boolean)geo1.disjoint(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln intersects(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return Bln.get((boolean)geo1.intersects(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln touches(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return Bln.get((boolean)geo1.touches(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln crosses(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return Bln.get((boolean)geo1.crosses(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln within(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return Bln.get((boolean)geo1.within(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln contains(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return Bln.get((boolean)geo1.contains(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln overlaps(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return Bln.get((boolean)geo1.overlaps(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln relate(ANode node1, ANode node2, Str intersectionMatrix) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        try {
            return Bln.get((boolean)geo1.relate(geo2, intersectionMatrix.toJava()));
        }
        catch (IllegalArgumentException ex) {
            Util.debug((Throwable)ex);
            throw GeoErrors.illegalArg(intersectionMatrix);
        }
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Dbl distance(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return Dbl.get((double)geo1.distance(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode buffer(ANode node, ANum distance) throws QueryException {
        return this.toElement(Geo.checkGeo(node).buffer(distance.dbl()));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode convexHull(ANode node) throws QueryException {
        return this.toElement(Geo.checkGeo(node).convexHull());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode intersection(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return this.toElement(geo1.intersection(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode union(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return this.toElement(geo1.union(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode difference(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return this.toElement(geo1.difference(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode symDifference(ANode node1, ANode node2) throws QueryException {
        Geometry geo1 = Geo.checkGeo(node1);
        Geometry geo2 = Geo.checkGeo(node2);
        return this.toElement(geo1.symDifference(geo2));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Int numGeometries(ANode node) throws QueryException {
        return Int.get((long)Geo.checkGeo(node).getNumGeometries());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode geometryN(ANode node, Int number) throws QueryException {
        Geometry geo = Geo.checkGeo(node);
        long n = number.itr();
        if (n < 1L || n > (long)geo.getNumGeometries()) {
            throw GeoErrors.outOfRangeIdx(number);
        }
        return this.toElement(geo.getGeometryN((int)n - 1));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Dbl x(ANode node) throws QueryException {
        Geometry geo = Geo.geo(node, "Point", Q_GML_POINT);
        return Dbl.get((double)geo.getCoordinate().x);
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Dbl y(ANode node) throws QueryException {
        Geometry geo = Geo.geo(node, "Point", Q_GML_POINT);
        return Dbl.get((double)geo.getCoordinate().y);
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Dbl z(ANode node) throws QueryException {
        Geometry geo = Geo.geo(node, "Point", Q_GML_POINT);
        return Dbl.get((double)geo.getCoordinate().z);
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Dbl length(ANode node) throws QueryException {
        return Dbl.get((double)Geo.checkGeo(node).getLength());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode startPoint(ANode node) throws QueryException {
        Geometry geo = Geo.geo(node, "Line", Q_GML_LINEARRING, Q_GML_LINESTRING);
        return this.toElement((Geometry)((LineString)geo).getStartPoint());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode endPoint(ANode node) throws QueryException {
        Geometry geo = Geo.geo(node, "Line", Q_GML_LINEARRING, Q_GML_LINESTRING);
        return this.toElement((Geometry)((LineString)geo).getEndPoint());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln isClosed(ANode node) throws QueryException {
        Geometry geo = Geo.geo(node, "Line", Q_GML_LINEARRING, Q_GML_LINESTRING, Q_GML_MULTILINESTRING);
        return Bln.get((boolean)(geo instanceof LineString ? ((LineString)geo).isClosed() : ((MultiLineString)geo).isClosed()));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Bln isRing(ANode node) throws QueryException {
        Geometry geo = Geo.geo(node, "Line", Q_GML_LINEARRING, Q_GML_LINESTRING);
        return Bln.get((boolean)((LineString)geo).isRing());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Int numPoints(ANode node) throws QueryException {
        return Int.get((long)Geo.checkGeo(node).getNumPoints());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode pointN(ANode node, Int number) throws QueryException {
        Geometry geo = Geo.geo(node, "Line", Q_GML_LINEARRING, Q_GML_LINESTRING);
        int max = geo.getNumPoints();
        long n = number.itr();
        if (n < 1L || n > (long)max) {
            throw GeoErrors.outOfRangeIdx(number);
        }
        return this.toElement((Geometry)((LineString)geo).getPointN((int)n - 1));
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Dbl area(ANode node) throws QueryException {
        return Dbl.get((double)Geo.checkGeo(node).getArea());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode centroid(ANode node) throws QueryException {
        return this.toElement((Geometry)Geo.checkGeo(node).getCentroid());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode pointOnSurface(ANode node) throws QueryException {
        return this.toElement((Geometry)Geo.checkGeo(node).getInteriorPoint());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode exteriorRing(ANode node) throws QueryException {
        Geometry geo = Geo.geo(node, "Polygon", Q_GML_POLYGON);
        return this.toElement((Geometry)((Polygon)geo).getExteriorRing());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public Int numInteriorRing(ANode node) throws QueryException {
        Geometry geo = Geo.geo(node, "Polygon", Q_GML_POLYGON);
        return Int.get((long)((Polygon)geo).getNumInteriorRing());
    }

    @QueryModule.Deterministic
    @QueryModule.Requires(value=QueryModule.Permission.NONE)
    public ANode interiorRingN(ANode node, Int number) throws QueryException {
        Geometry geo = Geo.geo(node, "Polygon", Q_GML_POLYGON);
        long n = number.itr();
        int max = ((Polygon)geo).getNumInteriorRing();
        if (n < 1L || n > (long)max) {
            throw GeoErrors.outOfRangeIdx(number);
        }
        return this.toElement((Geometry)((Polygon)geo).getInteriorRingN((int)n - 1));
    }

    private static Geometry checkGeo(ANode node) throws QueryException {
        Geometry geo = Geo.geo(node, QNAMES);
        if (geo == null) {
            throw GeoErrors.unrecognizedGeo(node.qname().local());
        }
        return geo;
    }

    private static Geometry geo(ANode node, String type, QNm ... names) throws QueryException {
        Geometry geo = Geo.geo(node, names);
        if (geo == null) {
            Geo.checkGeo(node);
            throw GeoErrors.geoType(node.qname().local(), type);
        }
        return geo;
    }

    private static Geometry geo(ANode node, QNm ... names) throws QueryException {
        if (node.type != NodeType.ELM) {
            throw QueryError.typeError((Value)node, (Type)NodeType.ELM, null);
        }
        QNm qname = node.qname();
        for (QNm geo : names) {
            if (!qname.eq(geo)) continue;
            try {
                String input = node.serialize().toString();
                GMLReader gmlReader = new GMLReader();
                GeometryFactory geoFactory = new GeometryFactory();
                return gmlReader.read(input, geoFactory);
            }
            catch (Throwable ex) {
                throw GeoErrors.gmlReaderErr(ex);
            }
        }
        return null;
    }

    private ANode toElement(Geometry geometry) throws QueryException {
        String geo;
        try {
            geo = new GMLWriter().write(geometry).replaceAll("^<gml:(.*?)>", "<gml:$1 xmlns:gml='" + Token.string((byte[])URI) + "'>");
        }
        catch (Exception ex) {
            throw GeoErrors.gmlWriterErr(ex);
        }
        try {
            XMLParser parser = new XMLParser((IO)new IOContent(geo), this.queryContext.context.options);
            return new DBNode((Data)MemBuilder.build((Parser)parser)).children().next();
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(null, new Object[]{ex});
        }
    }
}

