/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.realm.ldap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.exist.config.Configurable;
import org.exist.config.Configuration;
import org.exist.config.Configurator;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.security.AXSchemaType;
import org.exist.security.realm.ldap.LDAPPrincipalBlackList;
import org.exist.security.realm.ldap.LDAPPrincipalWhiteList;

@ConfigurationClass(value="")
public abstract class AbstractLDAPSearchPrincipal
implements Configurable {
    @ConfigurationFieldAsElement(value="search-filter-prefix")
    protected String searchFilterPrefix = null;
    @ConfigurationFieldAsElement(value="search-attribute")
    protected Map<String, String> searchAttributes = new HashMap<String, String>();
    @ConfigurationFieldAsElement(value="metadata-search-attribute")
    protected Map<String, String> metadataSearchAttributes = new HashMap<String, String>();
    @ConfigurationFieldAsElement(value="whitelist")
    protected LDAPPrincipalWhiteList whiteList = null;
    @ConfigurationFieldAsElement(value="blacklist")
    protected LDAPPrincipalBlackList blackList = null;
    protected Configuration configuration;

    public AbstractLDAPSearchPrincipal(Configuration config) {
        this.configuration = Configurator.configure((Configurable)this, (Configuration)config);
    }

    public String getSearchFilterPrefix() {
        return this.searchFilterPrefix;
    }

    public String getSearchAttribute(LDAPSearchAttributeKey ldapSearchAttributeKey) {
        return this.searchAttributes.get(ldapSearchAttributeKey.getKey());
    }

    public String getMetadataSearchAttribute(AXSchemaType axSchemaType) {
        return this.metadataSearchAttributes.get(axSchemaType.getNamespace());
    }

    public Set<AXSchemaType> getMetadataSearchAttributeKeys() {
        HashSet<AXSchemaType> metadataSearchAttributeKeys = new HashSet<AXSchemaType>();
        for (String key : this.metadataSearchAttributes.keySet()) {
            metadataSearchAttributeKeys.add(AXSchemaType.valueOfNamespace((String)key));
        }
        return metadataSearchAttributeKeys;
    }

    public boolean isConfigured() {
        return this.configuration != null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public LDAPPrincipalBlackList getBlackList() {
        return this.blackList;
    }

    public LDAPPrincipalWhiteList getWhiteList() {
        return this.whiteList;
    }

    public static enum LDAPSearchAttributeKey {
        NAME("name"),
        DN("dn"),
        MEMBER_OF("memberOf"),
        MEMBER("member"),
        PRIMARY_GROUP_TOKEN("primaryGroupToken"),
        PRIMARY_GROUP_ID("primaryGroupID"),
        OBJECT_SID("objectSid");

        private final String key;

        private LDAPSearchAttributeKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static LDAPSearchAttributeKey valueOfKey(String key) {
            for (LDAPSearchAttributeKey ldapSearchAttributeKey : LDAPSearchAttributeKey.values()) {
                if (!ldapSearchAttributeKey.getKey().equals(key)) continue;
                return ldapSearchAttributeKey;
            }
            return null;
        }
    }
}

